/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jboss.com.sun.tools.ws.wscompile.CompileTool;
import org.jboss.ws.tools.jaxws.api.WSContractConsumer;
import org.jboss.ws.tools.jaxws.impl.NullPrintStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSContractConsumerImpl
extends WSContractConsumer {
    private List<File> bindingFiles = null;
    private File catalog = null;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    private String targetPackage = null;
    private PrintStream messageStream = null;
    private String wsdlLocation = null;
    private List<String> additionalCompilerClassPath = null;

    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    public void consume(URL wsdl) {
        PrintStream stream;
        ArrayList<String> args = new ArrayList<String>();
        if (this.bindingFiles != null) {
            for (File file : this.bindingFiles) {
                args.add("-b");
                args.add(file.getAbsolutePath());
            }
        }
        if (this.catalog != null) {
            args.add("-catalog");
            args.add(this.catalog.getAbsolutePath());
        }
        if (this.generateSource) {
            args.add("-keep");
            if (this.sourceDir != null) {
                if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                    throw new IllegalStateException("Could not make directory: " + this.sourceDir.getName());
                }
                args.add("-s");
                args.add(this.sourceDir.getAbsolutePath());
            }
        }
        if (this.targetPackage != null) {
            args.add("-p");
            args.add(this.targetPackage);
        }
        if (this.wsdlLocation != null) {
            args.add("-wsdllocation");
            args.add(this.wsdlLocation);
        }
        if ((stream = this.messageStream) != null) {
            args.add("-verbose");
        } else {
            stream = new NullPrintStream();
        }
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Could not make directory: " + this.outputDir.getName());
        }
        args.add("-d");
        args.add(this.outputDir.getAbsolutePath());
        args.add(wsdl.toString());
        CompileTool tool = new CompileTool(stream, "wsimport"){

            public boolean run(String[] args) {
                StringBuilder builder = new StringBuilder();
                if (WSContractConsumerImpl.this.additionalCompilerClassPath != null && WSContractConsumerImpl.this.additionalCompilerClassPath.size() > 0) {
                    for (String entry : WSContractConsumerImpl.this.additionalCompilerClassPath) {
                        builder.append(entry).append(File.pathSeparatorChar);
                    }
                    builder.setLength(builder.length() - 1);
                }
                this.userClasspath = builder.toString();
                return super.run(args);
            }
        };
        tool.run(args.toArray(new String[0]));
    }
}

