/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.util.exception;

import javax.xml.ws.WebServiceException;
import org.jboss.com.sun.xml.ws.util.localization.Localizable;
import org.jboss.com.sun.xml.ws.util.localization.Localizer;

public abstract class JAXWSExceptionBase
extends WebServiceException
implements Localizable {
    private final String key;
    private final Object[] args;

    protected JAXWSExceptionBase(String key, Object ... args) {
        super(JAXWSExceptionBase.findNestedException(args));
        if (args == null) {
            args = new Object[]{};
        }
        this.key = key;
        this.args = args;
    }

    protected JAXWSExceptionBase(Throwable throwable) {
        super(throwable);
        this.key = Localizable.NOT_LOCALIZABLE;
        this.args = new Object[]{throwable.toString()};
    }

    private static Throwable findNestedException(Object[] args) {
        if (args == null) {
            return null;
        }
        for (Object o : args) {
            if (!(o instanceof Throwable)) continue;
            return (Throwable)o;
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public String toString() {
        return this.getMessage();
    }

    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }
}

