/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.transport.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.com.sun.xml.ws.transport.Headers;
import org.jboss.com.sun.xml.ws.transport.WSConnectionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletConnectionImpl
extends WSConnectionImpl {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private int status;
    private Map<String, List<String>> requestHeaders;
    private Map<String, List<String>> responseHeaders;

    public ServletConnectionImpl(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        if (this.requestHeaders == null) {
            this.requestHeaders = new Headers();
            Enumeration enums = this.request.getHeaderNames();
            while (enums.hasMoreElements()) {
                String headerName = (String)enums.nextElement();
                String headerValue = this.request.getHeader(headerName);
                List<String> values = this.requestHeaders.get(headerName);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.requestHeaders.put(headerName, values);
                }
                values.add(headerValue);
            }
        }
        return this.requestHeaders;
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
        this.responseHeaders = headers;
    }

    @Override
    public void setStatus(int status) {
        this.status = status;
    }

    @Override
    public int getStatus() {
        if (this.status == 0) {
            this.status = 200;
        }
        return this.status;
    }

    @Override
    public InputStream getInput() {
        try {
            return this.request.getInputStream();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    @Override
    public OutputStream getOutput() {
        this.response.setStatus(this.getStatus());
        if (this.responseHeaders != null) {
            for (Map.Entry<String, List<String>> entry : this.responseHeaders.entrySet()) {
                String name = entry.getKey();
                List<String> values = entry.getValue();
                for (String value : values) {
                    this.response.setHeader(name, value);
                }
            }
        }
        try {
            this.outputStream = this.response.getOutputStream();
            return this.outputStream;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }
}

