/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.com.sun.xml.ws.client.ClientTransportException;
import org.jboss.com.sun.xml.ws.spi.runtime.WSConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WSConnectionImpl
implements WSConnection {
    Map<String, List<String>> headers = null;
    public OutputStream debugStream = null;
    public OutputStream outputStream = null;
    public InputStream inputStream = null;
    int statusCode;

    @Override
    public int getStatus() {
        return this.statusCode;
    }

    @Override
    public void setStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    @Override
    public OutputStream getDebug() {
        return this.debugStream;
    }

    @Override
    public OutputStream getOutput() {
        return this.outputStream;
    }

    @Override
    public InputStream getInput() {
        return this.inputStream;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void writeHeaders(OutputStream os) {
        try {
            byte[] newLine = "\r\n".getBytes("us-ascii");
            Map<String, List<String>> headers = this.getHeaders();
            for (String header : headers.keySet()) {
                os.write((header + ":" + headers.get(header).get(0)).getBytes("us-ascii"));
                os.write(newLine);
            }
            os.write(newLine);
        }
        catch (Exception ex) {
            throw new ClientTransportException("local.client.failed", ex);
        }
    }

    public void readHeaders(InputStream is) {
        try {
            int c1;
            StringBuffer line = new StringBuffer();
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            } else {
                this.headers.clear();
            }
            while ((c1 = is.read()) != -1) {
                if (c1 == 13) {
                    int c2 = is.read();
                    assert (c2 != -1);
                    if (c2 == 10) {
                        String s = line.toString();
                        if (s.length() != 0) {
                            int k = s.indexOf(58);
                            assert (k > 0);
                            ArrayList<String> value = new ArrayList<String>();
                            value.add(s.substring(k + 1));
                            this.headers.put(s.substring(0, k), value);
                            line.setLength(0);
                            continue;
                        }
                        break;
                    }
                    line.append((char)c1).append((char)c2);
                    continue;
                }
                line.append((char)c1);
            }
        }
        catch (Exception ex) {
            throw new ClientTransportException("local.client.failed", ex);
        }
    }

    @Override
    public void closeOutput() {
        try {
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void closeInput() {
    }

    @Override
    public void close() {
    }
}

