/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.streaming;

import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.com.sun.xml.ws.streaming.XMLReaderException;
import org.jboss.com.sun.xml.ws.streaming.XMLStreamWriterException;
import org.jboss.com.sun.xml.ws.util.FastInfosetReflection;

public class XMLStreamWriterFactory {
    static XMLOutputFactory xmlOutputFactory;
    static ThreadLocal fiStreamWriter;

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out) {
        return XMLStreamWriterFactory.createXMLStreamWriter(out, "UTF-8");
    }

    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding) {
        return XMLStreamWriterFactory.createXMLStreamWriter(out, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamWriter createXMLStreamWriter(OutputStream out, String encoding, boolean declare) {
        try {
            XMLOutputFactory xMLOutputFactory = xmlOutputFactory;
            synchronized (xMLOutputFactory) {
                return xmlOutputFactory.createXMLStreamWriter(out, encoding);
            }
        }
        catch (Exception e) {
            throw new XMLReaderException("stax.cantCreate", e);
        }
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream out) {
        return XMLStreamWriterFactory.createFIStreamWriter(out, "UTF-8");
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream out, String encoding) {
        return XMLStreamWriterFactory.createFIStreamWriter(out, encoding, true);
    }

    public static XMLStreamWriter createFIStreamWriter(OutputStream out, String encoding, boolean declare) {
        if (FastInfosetReflection.fiStAXDocumentSerializer_new == null) {
            throw new XMLReaderException("fastinfoset.noImplementation", new Object[0]);
        }
        try {
            Object sds = fiStreamWriter.get();
            if (sds == null) {
                sds = FastInfosetReflection.fiStAXDocumentSerializer_new.newInstance(new Object[0]);
                fiStreamWriter.set(sds);
            }
            FastInfosetReflection.fiStAXDocumentSerializer_setOutputStream.invoke(sds, out);
            FastInfosetReflection.fiStAXDocumentSerializer_setEncoding.invoke(sds, encoding);
            return (XMLStreamWriter)sds;
        }
        catch (Exception e) {
            throw new XMLStreamWriterException(e);
        }
    }

    static {
        fiStreamWriter = new ThreadLocal();
        xmlOutputFactory = XMLOutputFactory.newInstance();
    }
}

