/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.spi.runtime;

import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.jboss.com.sun.xml.ws.spi.runtime.MessageContext;
import org.jboss.com.sun.xml.ws.spi.runtime.SystemHandlerDelegate;

public abstract class SystemHandlerDelegateFactory {
    private static final String DEFAULT_FACTORY_NAME = "com.sun.xml.xwss.SystemHandlerDelegateFactory";
    private static String factoryName;
    private static HashMap factoryMap;

    private static synchronized void init() {
        factoryName = DEFAULT_FACTORY_NAME;
        factoryMap = new HashMap();
    }

    public SystemHandlerDelegate getDelegate(QName serviceName) {
        return this.create();
    }

    public abstract SystemHandlerDelegate create();

    public abstract boolean isEnabled(MessageContext var1);

    public static synchronized void setFactoryName(String name) {
        factoryName = name;
    }

    public static synchronized String getFactoryName() {
        return factoryName;
    }

    public static synchronized SystemHandlerDelegateFactory getFactory() {
        SystemHandlerDelegateFactory factory = (SystemHandlerDelegateFactory)factoryMap.get(factoryName);
        if (factory != null || factoryMap.containsKey(factoryName)) {
            return factory;
        }
        Class<?> clazz = null;
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            clazz = loader == null ? Class.forName(factoryName) : loader.loadClass(factoryName);
            if (clazz != null) {
                factory = (SystemHandlerDelegateFactory)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            factory = null;
        }
        catch (Exception x) {
            throw new WebServiceException((Throwable)x);
        }
        finally {
            factoryMap.put(factoryName, factory);
        }
        return factory;
    }

    static {
        SystemHandlerDelegateFactory.init();
    }
}

