/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.jboss.com.sun.xml.ws.server.DocInfo;
import org.jboss.com.sun.xml.ws.server.RuntimeEndpointInfo;
import org.jboss.com.sun.xml.ws.server.ServerRtException;
import org.jboss.com.sun.xml.ws.wsdl.parser.WSDLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDLPatcher {
    private static final String NS_XSD = "http://www.w3.org/2001/XMLSchema";
    private static final QName QNAME_SCHEMA = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final QName SCHEMA_INCLUDE_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "include");
    private static final QName SCHEMA_IMPORT_QNAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final QName ATTR_NAME_QNAME = new QName("", "name");
    private static final QName ATTR_TARGETNS_QNAME = new QName("", "targetNamespace");
    private static final QName WSDL_LOCATION_QNAME = new QName("", "location");
    private static final QName SCHEMA_LOCATION_QNAME = new QName("", "schemaLocation");
    private static final XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private static final XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private static final XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.wsdl.patcher");
    private DocInfo docInfo;
    private String baseAddress;
    private RuntimeEndpointInfo targetEndpoint;
    private List<RuntimeEndpointInfo> endpoints;

    public WSDLPatcher(DocInfo docInfo, String baseAddress, RuntimeEndpointInfo targetEndpoint, List<RuntimeEndpointInfo> endpoints) {
        this.docInfo = docInfo;
        this.baseAddress = baseAddress;
        this.targetEndpoint = targetEndpoint;
        this.endpoints = endpoints;
    }

    public void patchDoc(InputStream in, OutputStream out) {
        XMLEventReader reader = null;
        XMLEventWriter writer = null;
        try {
            reader = inputFactory.createXMLEventReader(in);
            StartElement start = null;
            QName serviceName = null;
            QName portName = null;
            String targetNamespace = null;
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartDocument()) {
                    StartDocument sd = (StartDocument)event;
                    String encoding = sd.encodingSet() ? sd.getCharacterEncodingScheme() : null;
                    writer = encoding != null ? outputFactory.createXMLEventWriter(out, encoding) : outputFactory.createXMLEventWriter(out);
                } else if (event.isStartElement()) {
                    Attribute attr;
                    start = event.asStartElement();
                    QName name = start.getName();
                    if (name.equals(SCHEMA_INCLUDE_QNAME)) {
                        event = this.handleSchemaInclude(start);
                    } else if (name.equals(SCHEMA_IMPORT_QNAME)) {
                        event = this.handleSchemaImport(start);
                    } else if (name.equals(WSDLConstants.QNAME_IMPORT)) {
                        event = this.handleWSDLImport(start);
                    } else if (name.equals(WSDLConstants.NS_SOAP_BINDING_ADDRESS) || name.equals(WSDLConstants.NS_SOAP12_BINDING_ADDRESS)) {
                        event = this.handleSoapAddress(serviceName, portName, start);
                    } else if (name.equals(WSDLConstants.QNAME_DEFINITIONS)) {
                        attr = start.getAttributeByName(ATTR_TARGETNS_QNAME);
                        if (attr != null) {
                            targetNamespace = attr.getValue();
                        }
                    } else if (name.equals(WSDLConstants.QNAME_SERVICE)) {
                        attr = start.getAttributeByName(ATTR_NAME_QNAME);
                        if (attr != null) {
                            serviceName = new QName(targetNamespace, attr.getValue());
                        }
                    } else if (name.equals(WSDLConstants.QNAME_PORT) && (attr = start.getAttributeByName(ATTR_NAME_QNAME)) != null) {
                        portName = new QName(targetNamespace, attr.getValue());
                    }
                } else if (event.isEndElement()) {
                    start = null;
                }
                writer.add(event);
            }
        }
        catch (XMLStreamException e) {
            throw new ServerRtException("runtime.wsdl.patcher", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (XMLStreamException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getPatchedImportLocation(String relPath) {
        try {
            URL relUrl = new URL(this.docInfo.getUrl(), relPath);
            String query = this.targetEndpoint.getQueryString(relUrl);
            if (query == null) {
                return null;
            }
            String abs = this.baseAddress + this.targetEndpoint.getUrlPatternWithoutStar() + "?" + query;
            return abs;
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private XMLEvent patchImport(StartElement startElement, QName location) throws XMLStreamException {
        Attribute locationAttr = startElement.getAttributeByName(location);
        if (locationAttr == null) {
            return startElement;
        }
        ArrayList<Attribute> newAttrs = new ArrayList<Attribute>();
        Iterator<Attribute> i = startElement.getAttributes();
        while (i.hasNext()) {
            Attribute attr = i.next();
            String file = attr.getValue();
            if (attr.getName().equals(location)) {
                String relPath = attr.getValue();
                String absPath = this.getPatchedImportLocation(relPath);
                if (absPath == null) {
                    return startElement;
                }
                logger.fine("Fixing the relative location:" + relPath + " with absolute location:" + absPath);
                Attribute newAttr = eventFactory.createAttribute(location, absPath);
                newAttrs.add(newAttr);
                continue;
            }
            newAttrs.add(attr);
        }
        StartElement event = eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), newAttrs.iterator(), startElement.getNamespaces(), startElement.getNamespaceContext());
        return event;
    }

    private XMLEvent handleSchemaImport(StartElement startElement) throws XMLStreamException {
        return this.patchImport(startElement, SCHEMA_LOCATION_QNAME);
    }

    private XMLEvent handleSchemaInclude(StartElement startElement) throws XMLStreamException {
        return this.patchImport(startElement, SCHEMA_LOCATION_QNAME);
    }

    private XMLEvent handleWSDLImport(StartElement startElement) throws XMLStreamException {
        return this.patchImport(startElement, WSDL_LOCATION_QNAME);
    }

    private XMLEvent handleSoapAddress(QName service, QName port, StartElement startElement) throws XMLStreamException {
        ArrayList<Attribute> newAttrs = new ArrayList<Attribute>();
        Iterator<Attribute> i = startElement.getAttributes();
        while (i.hasNext()) {
            Attribute attr = i.next();
            String file = attr.getValue();
            if (attr.getName().equals(WSDL_LOCATION_QNAME)) {
                String value = this.getAddressLocation(service, port);
                if (value == null) {
                    return startElement;
                }
                logger.fine("Fixing service:" + service + " port:" + port + " address with " + value);
                Attribute newAttr = eventFactory.createAttribute(WSDL_LOCATION_QNAME, value);
                newAttrs.add(newAttr);
                continue;
            }
            newAttrs.add(attr);
        }
        StartElement event = eventFactory.createStartElement(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI(), startElement.getName().getLocalPart(), newAttrs.iterator(), startElement.getNamespaces(), startElement.getNamespaceContext());
        return event;
    }

    private String getAddressLocation(QName docServiceName, QName docPortName) {
        for (RuntimeEndpointInfo endpointInfo : this.endpoints) {
            QName serviceName = endpointInfo.getServiceName();
            QName portName = endpointInfo.getPortName();
            if (serviceName == null || portName == null || docServiceName == null || docPortName == null || !serviceName.equals(docServiceName) || !docPortName.equals(portName)) continue;
            return this.baseAddress + endpointInfo.getUrlPatternWithoutStar();
        }
        return null;
    }
}

