/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.soap.server;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.ws.handler.MessageContext;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPConstants;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPDecoder;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.InternalMessage;
import org.jboss.com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import org.jboss.com.sun.xml.ws.handler.HandlerContext;
import org.jboss.com.sun.xml.ws.handler.MessageContextUtil;
import org.jboss.com.sun.xml.ws.model.JavaMethod;
import org.jboss.com.sun.xml.ws.model.RuntimeModel;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.server.RuntimeContext;
import org.jboss.com.sun.xml.ws.server.ServerRtException;
import org.jboss.com.sun.xml.ws.streaming.SourceReaderFactory;
import org.jboss.com.sun.xml.ws.streaming.XMLStreamReaderUtil;
import org.jboss.com.sun.xml.ws.util.MessageInfoUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPXMLDecoder
extends SOAPDecoder {
    private static final Set<String> requiredRoles = new HashSet<String>();
    private static final QName emptyBodyName = new QName("");

    public SOAPXMLDecoder() {
        requiredRoles.add("http://schemas.xmlsoap.org/soap/actor/next");
        requiredRoles.add("");
    }

    @Override
    public InternalMessage toInternalMessage(SOAPMessage soapMessage, MessageInfo messageInfo) {
        InternalMessage internalMessage;
        block6: {
            XMLStreamReader reader = null;
            try {
                InternalMessage request = new InternalMessage();
                this.processAttachments(messageInfo, request, soapMessage);
                Source source = soapMessage.getSOAPPart().getContent();
                reader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(soapMessage));
                XMLStreamReaderUtil.nextElementContent(reader);
                this.decodeEnvelope(reader, request, false, messageInfo);
                internalMessage = request;
                if (reader == null) break block6;
            }
            catch (Exception e) {
                try {
                    if (this.isBadXML(e)) {
                        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
                        HandlerContext handlerCtxt = rtCtxt.getHandlerContext();
                        this.raiseBadXMLFault(handlerCtxt);
                    }
                    throw new ServerRtException("soapdecoder.err", e);
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        XMLStreamReaderUtil.close(reader);
                    }
                    throw throwable;
                }
            }
            XMLStreamReaderUtil.close(reader);
        }
        return internalMessage;
    }

    protected boolean isBadXML(Exception e) {
        while (e != null) {
            if (e instanceof XMLStreamException) {
                return true;
            }
            e = e.getCause() instanceof Exception ? (Exception)e.getCause() : null;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InternalMessage toInternalMessage(SOAPMessage soapMessage, InternalMessage request, MessageInfo messageInfo) {
        XMLStreamReader reader = null;
        try {
            this.processAttachments(messageInfo, request, soapMessage);
            Source source = soapMessage.getSOAPPart().getContent();
            reader = SourceReaderFactory.createSourceReader(source, true, this.getSOAPMessageCharsetEncoding(soapMessage));
            XMLStreamReaderUtil.nextElementContent(reader);
            this.decodeEnvelope(reader, request, true, messageInfo);
            this.convertBodyBlock(request, messageInfo);
            if (reader == null) return request;
        }
        catch (Exception e) {
            try {
                if (!this.isBadXML(e)) throw new ServerRtException("soapdecoder.err", e);
                RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
                HandlerContext handlerCtxt = rtCtxt.getHandlerContext();
                this.raiseBadXMLFault(handlerCtxt);
                throw new ServerRtException("soapdecoder.err", e);
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                XMLStreamReaderUtil.close(reader);
                throw throwable;
            }
        }
        XMLStreamReaderUtil.close(reader);
        return request;
    }

    @Override
    public void decodeDispatchMethod(XMLStreamReader reader, InternalMessage request, MessageInfo messageInfo) {
        MessageContext msgCtxt;
        Method method;
        QName name = reader.getEventType() == 1 ? reader.getName() : emptyBodyName;
        RuntimeContext rtCtxt = MessageInfoUtil.getRuntimeContext(messageInfo);
        RuntimeModel rtModel = rtCtxt.getModel();
        JavaMethod javaMethod = rtModel.getJavaMethod(name);
        Method method2 = method = javaMethod == null ? null : javaMethod.getMethod();
        if (method == null) {
            this.raiseFault(this.getSenderFaultCode(), "Cannot find the dispatch method");
        }
        if ((msgCtxt = MessageInfoUtil.getMessageContext(messageInfo)) != null) {
            String opNsUri = rtModel.getPortTypeName().getNamespaceURI();
            String opName = javaMethod.getOperationName();
            MessageContextUtil.setWsdlOperation(msgCtxt, new QName(opNsUri, opName));
        }
        messageInfo.setMethod(method);
    }

    @Override
    protected SOAPFaultInfo decodeFault(XMLStreamReader reader, InternalMessage internalMessage, MessageInfo messageInfo) {
        this.raiseFault(this.getSenderFaultCode(), "Server cannot handle fault message");
        return null;
    }

    @Override
    protected void raiseBadXMLFault(HandlerContext ctxt) {
        MessageContextUtil.setHttpStatusCode(ctxt.getMessageContext(), 400);
        this.raiseFault(this.getSenderFaultCode(), "Bad request");
    }

    @Override
    public Set<String> getRequiredRoles() {
        return requiredRoles;
    }

    @Override
    public String getBindingId() {
        return "http://schemas.xmlsoap.org/wsdl/soap/http";
    }

    @Override
    protected QName getSenderFaultCode() {
        return SOAPConstants.FAULT_CODE_CLIENT;
    }

    @Override
    protected QName getReceiverFaultCode() {
        return SOAPConstants.FAULT_CODE_SERVER;
    }

    @Override
    protected QName getVersionMismatchFaultCode() {
        return SOAPConstants.FAULT_CODE_VERSION_MISMATCH;
    }
}

