/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.soap.server;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.handler.MessageContext;
import org.jboss.com.sun.xml.ws.encoding.JAXWSAttachmentMarshaller;
import org.jboss.com.sun.xml.ws.encoding.soap.message.SOAP12FaultInfo;
import org.jboss.com.sun.xml.ws.encoding.soap.message.SOAPFaultInfo;
import org.jboss.com.sun.xml.ws.encoding.soap.server.SOAPXMLEncoder;
import org.jboss.com.sun.xml.ws.handler.MessageContextUtil;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.server.ServerRtException;
import org.jboss.com.sun.xml.ws.util.MessageInfoUtil;

public class SOAP12XMLEncoder
extends SOAPXMLEncoder {
    protected void startEnvelope(XMLStreamWriter writer) {
        try {
            writer.writeStartElement("soapenv", "Envelope", "http://www.w3.org/2003/05/soap-envelope");
            writer.setPrefix("soapenv", "http://www.w3.org/2003/05/soap-envelope");
            writer.writeNamespace("soapenv", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (XMLStreamException e) {
            throw new ServerRtException(e);
        }
    }

    protected void startBody(XMLStreamWriter writer) {
        try {
            writer.writeStartElement("soapenv", "Body", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (XMLStreamException e) {
            throw new ServerRtException(e);
        }
    }

    protected void startHeader(XMLStreamWriter writer) {
        try {
            writer.writeStartElement("soapenv", "Header", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (XMLStreamException e) {
            throw new ServerRtException(e);
        }
    }

    protected void writeFault(SOAPFaultInfo faultInfo, MessageInfo messageInfo, XMLStreamWriter writer) {
        if (!(faultInfo instanceof SOAP12FaultInfo)) {
            return;
        }
        MessageContext ctxt = MessageInfoUtil.getMessageContext(messageInfo);
        if (MessageContextUtil.getHttpStatusCode(ctxt) == null) {
            MessageContextUtil.setHttpStatusCode(ctxt, 500);
        }
        ((SOAP12FaultInfo)faultInfo).write(writer, messageInfo);
    }

    protected String getContentType(MessageInfo messageInfo, JAXWSAttachmentMarshaller marshaller) {
        String contentNegotiation = (String)messageInfo.getMetaData("com.sun.xml.ws.client.ContentNegotiation");
        if (marshaller == null) {
            marshaller = this.getAttachmentMarshaller(messageInfo);
        }
        if (marshaller != null && marshaller.isXopped()) {
            return "application/xop+xml;type=\"application/soap+xml\"";
        }
        return contentNegotiation == "optimistic" ? "application/soap+fastinfoset" : "application/soap+xml";
    }

    protected String getBindingId() {
        return "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    }
}

