/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.encoding.soap.internal;

import javax.xml.ws.BindingProvider;
import org.jboss.com.sun.xml.ws.binding.BindingImpl;
import org.jboss.com.sun.xml.ws.client.ContactInfoBase;
import org.jboss.com.sun.xml.ws.client.ContextMap;
import org.jboss.com.sun.xml.ws.client.WSServiceDelegate;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.MessageInfoBase;
import org.jboss.com.sun.xml.ws.pept.Delegate;
import org.jboss.com.sun.xml.ws.pept.ept.ContactInfo;
import org.jboss.com.sun.xml.ws.pept.ept.ContactInfoList;
import org.jboss.com.sun.xml.ws.pept.ept.ContactInfoListIterator;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.pept.presentation.MessageStruct;
import org.jboss.com.sun.xml.ws.pept.protocol.MessageDispatcher;

public class DelegateBase
implements Delegate {
    protected ContactInfoList contactInfoList;
    protected WSServiceDelegate service;

    public DelegateBase() {
    }

    public DelegateBase(ContactInfoList contactInfoList) {
        this.contactInfoList = contactInfoList;
    }

    public DelegateBase(ContactInfoList cil, WSServiceDelegate service) {
        this(cil);
        this.service = service;
    }

    public MessageStruct getMessageStruct() {
        return new MessageInfoBase();
    }

    public void send(MessageStruct messageStruct) {
        MessageInfo messageInfo = (MessageInfo)messageStruct;
        if (!this.contactInfoList.iterator().hasNext()) {
            throw new RuntimeException("can't pickup message encoder/decoder, no ContactInfo!");
        }
        ContextMap properties = (ContextMap)messageInfo.getMetaData("org.jboss.com.sun.xml.ws.context.request");
        BindingProvider stub = (BindingProvider)properties.get("org.jboss.com.sun.xml.ws.client.handle");
        BindingImpl bi = (BindingImpl)stub.getBinding();
        String bindingId = bi.getBindingId();
        ContactInfo contactInfo = this.getContactInfo(this.contactInfoList, bindingId);
        messageInfo.setEPTFactory(contactInfo);
        MessageDispatcher messageDispatcher = contactInfo.getMessageDispatcher(messageInfo);
        messageDispatcher.send(messageInfo);
    }

    private ContactInfo getContactInfo(ContactInfoList cil, String bindingId) {
        ContactInfoListIterator iter = cil.iterator();
        while (iter.hasNext()) {
            ContactInfoBase cib = (ContactInfoBase)iter.next();
            if (!cib.getBindingId().equals(bindingId)) continue;
            return cib;
        }
        return cil.iterator().next();
    }
}

