/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.client.dispatch.impl;

import java.util.logging.Logger;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import org.jboss.com.sun.xml.ws.binding.BindingImpl;
import org.jboss.com.sun.xml.ws.client.ContactInfoBase;
import org.jboss.com.sun.xml.ws.client.ContextMap;
import org.jboss.com.sun.xml.ws.client.RequestContext;
import org.jboss.com.sun.xml.ws.encoding.soap.internal.DelegateBase;
import org.jboss.com.sun.xml.ws.pept.ept.ContactInfo;
import org.jboss.com.sun.xml.ws.pept.ept.ContactInfoList;
import org.jboss.com.sun.xml.ws.pept.ept.ContactInfoListIterator;
import org.jboss.com.sun.xml.ws.pept.ept.MessageInfo;
import org.jboss.com.sun.xml.ws.pept.presentation.MessageStruct;
import org.jboss.com.sun.xml.ws.pept.protocol.MessageDispatcher;

public class DispatchDelegate
extends DelegateBase {
    private static final Logger logger = Logger.getLogger(new StringBuffer().append("javax.enterprise.resource.webservices.jaxws").append(".client.dispatch").toString());

    public DispatchDelegate() {
    }

    public DispatchDelegate(ContactInfoList contactInfoList) {
        this.contactInfoList = contactInfoList;
    }

    public void send(MessageStruct messageStruct) {
        MessageInfo messageInfo = (MessageInfo)messageStruct;
        ContextMap properties = (ContextMap)messageInfo.getMetaData("org.jboss.com.sun.xml.ws.context.request");
        BindingProvider dispatch = (BindingProvider)properties.get("org.jboss.com.sun.xml.ws.client.handle");
        if (!this.contactInfoList.iterator().hasNext()) {
            throw new WebServiceException("can't pickup message encoder/decoder, no ContactInfo!");
        }
        BindingImpl bi = (BindingImpl)dispatch.getBinding();
        String bindingId = bi.getBindingId();
        ContactInfo contactInfo = this.getContactInfo(this.contactInfoList, bindingId);
        messageInfo.setEPTFactory(contactInfo);
        messageInfo.setConnection(contactInfo.getConnection(messageInfo));
        MessageDispatcher messageDispatcher = contactInfo.getMessageDispatcher(messageInfo);
        messageDispatcher.send(messageInfo);
    }

    private ContactInfo getContactInfo(ContactInfoList cil, String bindingId) {
        ContactInfoListIterator iter = cil.iterator();
        while (iter.hasNext()) {
            ContactInfoBase cib = (ContactInfoBase)iter.next();
            if (!cib.getBindingId().equals(bindingId)) continue;
            return cib;
        }
        return cil.iterator().next();
    }

    private void setDefaultEncoding(RequestContext requestContext) {
        requestContext.put("accept.encoding", (Object)"xml.encoding");
    }
}

