/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.wsdl.parser;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.com.sun.tools.ws.wsdl.document.schema.Schema;
import org.jboss.com.sun.tools.ws.wsdl.document.schema.SchemaAttribute;
import org.jboss.com.sun.tools.ws.wsdl.document.schema.SchemaDocument;
import org.jboss.com.sun.tools.ws.wsdl.document.schema.SchemaElement;
import org.jboss.com.sun.tools.ws.wsdl.framework.WriterContext;

public class SchemaWriter {
    public void write(SchemaDocument document, OutputStream os) throws IOException {
        WriterContext context = new WriterContext(os);
        this.writeSchema(context, document.getSchema());
        context.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSchema(WriterContext context, Schema schema) throws IOException {
        context.push();
        try {
            this.writeTopSchemaElement(context, schema);
        }
        catch (Exception exception) {
        }
        finally {
            context.pop();
        }
    }

    protected void writeTopSchemaElement(WriterContext context, Schema schema) throws IOException {
        String prefix;
        SchemaElement schemaElement = schema.getContent();
        QName name = schemaElement.getQName();
        Iterator iter = schema.prefixes();
        while (iter.hasNext()) {
            prefix = (String)iter.next();
            String expectedURI = schema.getURIForPrefix(prefix);
            if (expectedURI.equals(context.getNamespaceURI(prefix))) continue;
            context.declarePrefix(prefix, expectedURI);
        }
        iter = schemaElement.prefixes();
        while (iter.hasNext()) {
            prefix = (String)iter.next();
            String uri = schemaElement.getURIForPrefix(prefix);
            context.declarePrefix(prefix, uri);
        }
        context.writeStartTag(name);
        iter = schemaElement.attributes();
        while (iter.hasNext()) {
            SchemaAttribute attribute = (SchemaAttribute)iter.next();
            if (attribute.getNamespaceURI() == null) {
                context.writeAttribute(attribute.getLocalName(), attribute.getValue(context));
                continue;
            }
            context.writeAttribute(context.getQNameString(attribute.getQName()), attribute.getValue(context));
        }
        context.writeAllPendingNamespaceDeclarations();
        iter = schemaElement.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            this.writeSchemaElement(context, child);
        }
        context.writeEndTag(name);
    }

    protected void writeSchemaElement(WriterContext context, SchemaElement schemaElement) throws IOException {
        Iterator iter;
        QName name = schemaElement.getQName();
        if (schemaElement.declaresPrefixes()) {
            context.push();
        }
        context.writeStartTag(name);
        if (schemaElement.declaresPrefixes()) {
            iter = schemaElement.prefixes();
            while (iter.hasNext()) {
                String prefix = (String)iter.next();
                String uri = schemaElement.getURIForPrefix(prefix);
                context.writeNamespaceDeclaration(prefix, uri);
                context.declarePrefix(prefix, uri);
            }
        }
        iter = schemaElement.attributes();
        while (iter.hasNext()) {
            SchemaAttribute attribute = (SchemaAttribute)iter.next();
            if (attribute.getNamespaceURI() == null) {
                context.writeAttribute(attribute.getLocalName(), attribute.getValue(context));
                continue;
            }
            context.writeAttribute(context.getQNameString(attribute.getQName()), attribute.getValue(context));
        }
        iter = schemaElement.children();
        while (iter.hasNext()) {
            SchemaElement child = (SchemaElement)iter.next();
            this.writeSchemaElement(context, child);
        }
        context.writeEndTag(name);
        if (schemaElement.declaresPrefixes()) {
            context.pop();
        }
    }
}

