/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.wsdl.document;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.com.sun.tools.ws.wsdl.document.Definitions;
import org.jboss.com.sun.tools.ws.wsdl.document.Port;
import org.jboss.com.sun.tools.ws.wsdl.document.Service;
import org.jboss.com.sun.tools.ws.wsdl.document.WSDLDocumentVisitor;
import org.jboss.com.sun.tools.ws.wsdl.framework.AbstractDocument;
import org.jboss.com.sun.tools.ws.wsdl.framework.Entity;
import org.jboss.com.sun.tools.ws.wsdl.framework.EntityAction;
import org.jboss.com.sun.tools.ws.wsdl.framework.EntityReferenceAction;
import org.jboss.com.sun.tools.ws.wsdl.framework.EntityReferenceValidator;
import org.jboss.com.sun.tools.ws.wsdl.framework.GloballyKnown;
import org.jboss.com.sun.tools.ws.wsdl.framework.Kind;
import org.jboss.com.sun.tools.ws.wsdl.framework.NoSuchEntityException;
import org.jboss.com.sun.tools.ws.wsdl.framework.ValidationException;

public class WSDLDocument
extends AbstractDocument {
    private Definitions _definitions;

    public Definitions getDefinitions() {
        return this._definitions;
    }

    public void setDefinitions(Definitions d) {
        this._definitions = d;
    }

    public Set collectAllNamespaces() {
        Set result = super.collectAllNamespaces();
        if (this._definitions.getTargetNamespaceURI() != null) {
            result.add(this._definitions.getTargetNamespaceURI());
        }
        return result;
    }

    public QName[] getAllServiceQNames() {
        ArrayList<QName> serviceQNames = new ArrayList<QName>();
        Iterator<Service> iter = this.getDefinitions().services();
        while (iter.hasNext()) {
            Service next = iter.next();
            String targetNamespace = next.getDefining().getTargetNamespaceURI();
            String localName = next.getName();
            QName serviceQName = new QName(targetNamespace, localName);
            serviceQNames.add(serviceQName);
        }
        return serviceQNames.toArray(new QName[serviceQNames.size()]);
    }

    public QName[] getAllPortQNames() {
        ArrayList<QName> portQNames = new ArrayList<QName>();
        Iterator<Service> iter = this.getDefinitions().services();
        while (iter.hasNext()) {
            Service next = iter.next();
            Iterator<Port> piter = next.ports();
            while (piter.hasNext()) {
                Port pnext = piter.next();
                String targetNamespace = pnext.getDefining().getTargetNamespaceURI();
                String localName = pnext.getName();
                QName portQName = new QName(targetNamespace, localName);
                portQNames.add(portQName);
            }
        }
        return portQNames.toArray(new QName[portQNames.size()]);
    }

    public QName[] getPortQNames(String serviceNameLocalPart) {
        ArrayList<QName> portQNames = new ArrayList<QName>();
        Iterator<Service> iter = this.getDefinitions().services();
        while (iter.hasNext()) {
            Service next = iter.next();
            if (!next.getName().equals(serviceNameLocalPart)) continue;
            Iterator<Port> piter = next.ports();
            while (piter.hasNext()) {
                Port pnext = piter.next();
                String targetNamespace = pnext.getDefining().getTargetNamespaceURI();
                String localName = pnext.getName();
                QName portQName = new QName(targetNamespace, localName);
                portQNames.add(portQName);
            }
        }
        return portQNames.toArray(new QName[portQNames.size()]);
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        this._definitions.accept(visitor);
    }

    public void validate(EntityReferenceValidator validator) {
        GloballyValidatingAction action = new GloballyValidatingAction(this, validator);
        this.withAllSubEntitiesDo(action);
        if (action.getException() != null) {
            throw action.getException();
        }
    }

    protected Entity getRoot() {
        return this._definitions;
    }

    private class GloballyValidatingAction
    implements EntityAction,
    EntityReferenceAction {
        private ValidationException _exception;
        private AbstractDocument _document;
        private EntityReferenceValidator _validator;

        public GloballyValidatingAction(AbstractDocument document, EntityReferenceValidator validator) {
            this._document = document;
            this._validator = validator;
        }

        public void perform(Entity entity) {
            block2: {
                try {
                    entity.validateThis();
                    entity.withAllEntityReferencesDo(this);
                    entity.withAllSubEntitiesDo(this);
                }
                catch (ValidationException e) {
                    if (this._exception != null) break block2;
                    this._exception = e;
                }
            }
        }

        public void perform(Kind kind, QName name) {
            block2: {
                try {
                    GloballyKnown entity = this._document.find(kind, name);
                }
                catch (NoSuchEntityException e) {
                    if (this._exception != null || this._validator != null && this._validator.isValid(kind, name)) break block2;
                    this._exception = e;
                }
            }
        }

        public ValidationException getException() {
            return this._exception;
        }
    }
}

