/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.wsdl.document;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.com.sun.tools.ws.wsdl.document.Documentation;
import org.jboss.com.sun.tools.ws.wsdl.document.Kinds;
import org.jboss.com.sun.tools.ws.wsdl.document.MessagePart;
import org.jboss.com.sun.tools.ws.wsdl.document.WSDLConstants;
import org.jboss.com.sun.tools.ws.wsdl.document.WSDLDocumentVisitor;
import org.jboss.com.sun.tools.ws.wsdl.framework.Defining;
import org.jboss.com.sun.tools.ws.wsdl.framework.EntityAction;
import org.jboss.com.sun.tools.ws.wsdl.framework.GlobalEntity;
import org.jboss.com.sun.tools.ws.wsdl.framework.Kind;
import org.jboss.com.sun.tools.ws.wsdl.framework.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends GlobalEntity {
    private Documentation _documentation;
    private List<MessagePart> _parts = new ArrayList<MessagePart>();
    private Map<String, MessagePart> _partsByName = new HashMap<String, MessagePart>();

    public Message(Defining defining) {
        super(defining);
    }

    public void add(MessagePart part) {
        if (this._partsByName.get(part.getName()) != null) {
            throw new ValidationException("validation.duplicateName", part.getName());
        }
        this._partsByName.put(part.getName(), part);
        this._parts.add(part);
    }

    public Iterator<MessagePart> parts() {
        return this._parts.iterator();
    }

    public List<MessagePart> getParts() {
        return this._parts;
    }

    public MessagePart getPart(String name) {
        return this._partsByName.get(name);
    }

    public int numParts() {
        return this._parts.size();
    }

    @Override
    public Kind getKind() {
        return Kinds.MESSAGE;
    }

    @Override
    public QName getElementName() {
        return WSDLConstants.QNAME_MESSAGE;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction action) {
        super.withAllSubEntitiesDo(action);
        Iterator<MessagePart> iter = this._parts.iterator();
        while (iter.hasNext()) {
            action.perform(iter.next());
        }
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        Iterator<MessagePart> iter = this._parts.iterator();
        while (iter.hasNext()) {
            iter.next().accept(visitor);
        }
        visitor.postVisit(this);
    }

    @Override
    public void validateThis() {
        if (this.getName() == null) {
            this.failValidation("validation.missingRequiredAttribute", "name");
        }
    }
}

