/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.wsdl.document;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.com.sun.tools.ws.wsdl.document.Binding;
import org.jboss.com.sun.tools.ws.wsdl.document.Documentation;
import org.jboss.com.sun.tools.ws.wsdl.document.Import;
import org.jboss.com.sun.tools.ws.wsdl.document.Message;
import org.jboss.com.sun.tools.ws.wsdl.document.PortType;
import org.jboss.com.sun.tools.ws.wsdl.document.Service;
import org.jboss.com.sun.tools.ws.wsdl.document.Types;
import org.jboss.com.sun.tools.ws.wsdl.document.WSDLConstants;
import org.jboss.com.sun.tools.ws.wsdl.document.WSDLDocumentVisitor;
import org.jboss.com.sun.tools.ws.wsdl.framework.AbstractDocument;
import org.jboss.com.sun.tools.ws.wsdl.framework.Defining;
import org.jboss.com.sun.tools.ws.wsdl.framework.Entity;
import org.jboss.com.sun.tools.ws.wsdl.framework.EntityAction;
import org.jboss.com.sun.tools.ws.wsdl.framework.ExtensibilityHelper;
import org.jboss.com.sun.tools.ws.wsdl.framework.Extensible;
import org.jboss.com.sun.tools.ws.wsdl.framework.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Definitions
extends Entity
implements Defining,
Extensible {
    private AbstractDocument _document;
    private ExtensibilityHelper _helper;
    private Documentation _documentation;
    private String _name;
    private String _targetNsURI;
    private Types _types;
    private List _messages;
    private List _portTypes;
    private List _bindings;
    private List<Service> _services;
    private List _imports;
    private Set _importedNamespaces;

    public Definitions(AbstractDocument document) {
        this._document = document;
        this._bindings = new ArrayList();
        this._imports = new ArrayList();
        this._messages = new ArrayList();
        this._portTypes = new ArrayList();
        this._services = new ArrayList<Service>();
        this._importedNamespaces = new HashSet();
        this._helper = new ExtensibilityHelper();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String s) {
        this._name = s;
    }

    @Override
    public String getTargetNamespaceURI() {
        return this._targetNsURI;
    }

    public void setTargetNamespaceURI(String s) {
        this._targetNsURI = s;
    }

    public void setTypes(Types t) {
        this._types = t;
    }

    public Types getTypes() {
        return this._types;
    }

    public void add(Message m) {
        this._document.define(m);
        this._messages.add(m);
    }

    public void add(PortType p) {
        this._document.define(p);
        this._portTypes.add(p);
    }

    public void add(Binding b) {
        this._document.define(b);
        this._bindings.add(b);
    }

    public void add(Service s) {
        this._document.define(s);
        this._services.add(s);
    }

    public void addServiceOveride(Service s) {
        this._services.add(s);
    }

    public void add(Import i) {
        this._imports.add(i);
        this._importedNamespaces.add(i.getNamespace());
    }

    public Iterator imports() {
        return this._imports.iterator();
    }

    public Iterator messages() {
        return this._messages.iterator();
    }

    public Iterator portTypes() {
        return this._portTypes.iterator();
    }

    public Iterator bindings() {
        return this._bindings.iterator();
    }

    public Iterator<Service> services() {
        return this._services.iterator();
    }

    @Override
    public QName getElementName() {
        return WSDLConstants.QNAME_DEFINITIONS;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    @Override
    public void addExtension(Extension e) {
        this._helper.addExtension(e);
    }

    @Override
    public Iterator extensions() {
        return this._helper.extensions();
    }

    @Override
    public void withAllSubEntitiesDo(EntityAction action) {
        if (this._types != null) {
            action.perform(this._types);
        }
        Iterator<Object> iter = this._messages.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this._portTypes.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this._bindings.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this._services.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this._imports.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        this._helper.withAllSubEntitiesDo(action);
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        Iterator<Object> iter = this._imports.iterator();
        while (iter.hasNext()) {
            ((Import)iter.next()).accept(visitor);
        }
        if (this._types != null) {
            this._types.accept(visitor);
        }
        iter = this._messages.iterator();
        while (iter.hasNext()) {
            ((Message)iter.next()).accept(visitor);
        }
        iter = this._portTypes.iterator();
        while (iter.hasNext()) {
            ((PortType)iter.next()).accept(visitor);
        }
        iter = this._bindings.iterator();
        while (iter.hasNext()) {
            ((Binding)iter.next()).accept(visitor);
        }
        iter = this._services.iterator();
        while (iter.hasNext()) {
            ((Service)iter.next()).accept(visitor);
        }
        this._helper.accept(visitor);
        visitor.postVisit(this);
    }

    @Override
    public void validateThis() {
    }
}

