/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.processor.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.Provider;
import org.jboss.com.sun.tools.ws.processor.config.HandlerChainInfo;
import org.jboss.com.sun.tools.ws.processor.model.ModelException;
import org.jboss.com.sun.tools.ws.processor.model.ModelObject;
import org.jboss.com.sun.tools.ws.processor.model.ModelVisitor;
import org.jboss.com.sun.tools.ws.processor.model.Operation;
import org.jboss.com.sun.tools.ws.processor.model.java.JavaInterface;
import org.jboss.com.sun.tools.ws.wsdl.document.soap.SOAPStyle;
import org.jboss.com.sun.xml.ws.encoding.soap.SOAPVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Port
extends ModelObject {
    private SOAPStyle _style = null;
    private boolean _isWrapped = true;
    private String portGetter;
    private QName _name;
    private List<Operation> _operations = new ArrayList<Operation>();
    private JavaInterface _javaInterface;
    private String _address;
    private String _serviceImplName;
    private Map operationsByName = new HashMap();
    private HandlerChainInfo _clientHandlerChainInfo;
    private HandlerChainInfo _serverHandlerChainInfo;
    private SOAPVersion _soapVersion = SOAPVersion.SOAP_11;

    public Port() {
    }

    public Port(QName name) {
        this._name = name;
    }

    public QName getName() {
        return this._name;
    }

    public void setName(QName n) {
        this._name = n;
    }

    public void addOperation(Operation operation) {
        this._operations.add(operation);
        this.operationsByName.put(operation.getUniqueName(), operation);
    }

    public Operation getOperationByUniqueName(String name) {
        if (this.operationsByName.size() != this._operations.size()) {
            this.initializeOperationsByName();
        }
        return (Operation)this.operationsByName.get(name);
    }

    private void initializeOperationsByName() {
        this.operationsByName = new HashMap();
        if (this._operations != null) {
            for (Operation operation : this._operations) {
                if (operation.getUniqueName() != null && this.operationsByName.containsKey(operation.getUniqueName())) {
                    throw new ModelException("model.uniqueness", new Object[0]);
                }
                this.operationsByName.put(operation.getUniqueName(), operation);
            }
        }
    }

    public List<Operation> getOperations() {
        return this._operations;
    }

    public void setOperations(List<Operation> l) {
        this._operations = l;
    }

    public JavaInterface getJavaInterface() {
        return this._javaInterface;
    }

    public void setJavaInterface(JavaInterface i) {
        this._javaInterface = i;
    }

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String s) {
        this._address = s;
    }

    public HandlerChainInfo getClientHandlerChainInfo() {
        if (this._clientHandlerChainInfo == null) {
            this._clientHandlerChainInfo = new HandlerChainInfo();
        }
        return this._clientHandlerChainInfo;
    }

    public void setClientHandlerChainInfo(HandlerChainInfo i) {
        this._clientHandlerChainInfo = i;
    }

    public HandlerChainInfo getServerHandlerChainInfo() {
        if (this._serverHandlerChainInfo == null) {
            this._serverHandlerChainInfo = new HandlerChainInfo();
        }
        return this._serverHandlerChainInfo;
    }

    public void setServerHandlerChainInfo(HandlerChainInfo i) {
        this._serverHandlerChainInfo = i;
    }

    public SOAPVersion getSOAPVersion() {
        return this._soapVersion;
    }

    public void setSOAPVersion(SOAPVersion soapVersion) {
        this._soapVersion = soapVersion;
    }

    public String getServiceImplName() {
        return this._serviceImplName;
    }

    public void setServiceImplName(String name) {
        this._serviceImplName = name;
    }

    @Override
    public void accept(ModelVisitor visitor) throws Exception {
        visitor.visit(this);
    }

    public boolean isProvider() {
        String sei;
        JavaInterface intf = this.getJavaInterface();
        return intf != null && (sei = intf.getName()).equals(Provider.class.getName());
    }

    public String getPortGetter() {
        return this.portGetter;
    }

    public void setPortGetter(String portGetterName) {
        this.portGetter = portGetterName;
    }

    public SOAPStyle getStyle() {
        return this._style;
    }

    public void setStyle(SOAPStyle s) {
        this._style = s;
    }

    public boolean isWrapped() {
        return this._isWrapped;
    }

    public void setWrapped(boolean isWrapped) {
        this._isWrapped = isWrapped;
    }
}

