/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.ant;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.XMLCatalog;
import org.jboss.com.sun.tools.ws.wscompile.CompileTool;
import org.xml.sax.EntityResolver;

public class WsImport
extends MatchingTask {
    private CommandlineJava cmd = new CommandlineJava();
    private File destDir = null;
    private String wsdlLocation;
    private XMLCatalog xmlCatalog;
    private String pkg;
    protected boolean extension;
    private boolean keep = false;
    private boolean fork = false;
    private boolean optimize = false;
    private File sourcedestdir;
    protected boolean verbose = false;
    private boolean debug = false;
    private boolean includeAntRuntime = false;
    private boolean includeJavaRuntime = false;
    private String binding;
    private File catalog;
    private String wsdl;
    private Set<File> bindingFiles = new HashSet<File>();

    public File getDestdir() {
        return this.destDir;
    }

    public void setDestdir(File base) {
        this.destDir = base;
    }

    public String getWsdllocation() {
        return this.wsdlLocation;
    }

    public void setWsdllocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void addConfiguredXMLCatalog(XMLCatalog entityResolver) {
        if (this.xmlCatalog == null) {
            this.xmlCatalog = new XMLCatalog();
            this.xmlCatalog.setProject(this.getProject());
        }
        this.xmlCatalog.addConfiguredXMLCatalog(entityResolver);
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public String getPackage() {
        return this.pkg;
    }

    public Commandline.Argument createJvmarg() {
        return this.cmd.createVmArgument();
    }

    public boolean getExtension() {
        return this.extension;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public boolean getKeep() {
        return this.keep;
    }

    public void setKeep(boolean keep) {
        this.keep = keep;
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    public boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public void setSourcedestdir(File sourceBase) {
        this.keep = true;
        this.sourcedestdir = sourceBase;
    }

    public File getSourcedestdir() {
        return this.sourcedestdir;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setIncludeantruntime(boolean include) {
        this.includeAntRuntime = include;
    }

    public boolean getIncludeantruntime() {
        return this.includeAntRuntime;
    }

    public void setIncludejavaruntime(boolean include) {
        this.includeJavaRuntime = include;
    }

    public boolean getIncludejavaruntime() {
        return this.includeJavaRuntime;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public File getCatalog() {
        return this.catalog;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public void addConfiguredBinding(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.project);
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (int i = 0; i < includedFiles.length; ++i) {
            this.bindingFiles.add(new File(baseDir, includedFiles[i]));
        }
    }

    private void setupWsimportForkCommand() {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        Path classpath = new Path(this.project);
        if (loader instanceof AntClassLoader) {
            classpath = new Path(this.project, ((AntClassLoader)loader).getClasspath());
        }
        this.cmd.createClasspath(this.getProject()).append(classpath);
        this.cmd.setClassname("org.jboss.com.sun.tools.ws.WsImport");
    }

    private void setupWsimportArgs() {
        if (null != this.getDestdir() && !this.getDestdir().getName().equals("")) {
            this.cmd.createArgument().setValue("-d");
            this.cmd.createArgument().setFile(this.getDestdir());
        }
        if (this.getExtension()) {
            this.cmd.createArgument().setValue("-extension");
        }
        if (this.getDebug()) {
            this.cmd.createArgument().setValue("-g");
        }
        if (this.getKeep()) {
            this.cmd.createArgument().setValue("-keep");
        }
        if (this.getOptimize()) {
            this.cmd.createArgument().setValue("-O");
        }
        if (null != this.getSourcedestdir() && !this.getSourcedestdir().getName().equals("")) {
            this.cmd.createArgument().setValue("-s");
            this.cmd.createArgument().setFile(this.getSourcedestdir());
        }
        if (this.getCatalog() != null && this.getCatalog().getName().length() > 0) {
            this.cmd.createArgument().setValue("-catalog");
            this.cmd.createArgument().setFile(this.getCatalog());
        }
        if (this.getVerbose()) {
            this.cmd.createArgument().setValue("-verbose");
        }
        if (this.getWsdl() != null) {
            this.cmd.createArgument().setValue(this.getWsdl());
        }
        if (this.getPackage() != null && this.getPackage().length() > 0) {
            this.cmd.createArgument().setValue("-p");
            this.cmd.createArgument().setValue(this.getPackage());
        }
        if (this.getBinding() != null) {
            this.cmd.createArgument().setValue("-b");
            this.cmd.createArgument().setFile(new File(this.getBinding()));
        }
        if (this.wsdlLocation != null && this.wsdlLocation.length() != 0) {
            this.cmd.createArgument().setValue("-wsdllocation");
            this.cmd.createArgument().setValue(this.wsdlLocation);
        }
        if (!this.bindingFiles.isEmpty()) {
            for (File binding : this.bindingFiles) {
                this.cmd.createArgument().setValue("-b");
                this.cmd.createArgument().setFile(binding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        LogOutputStream logstr = null;
        boolean ok = false;
        try {
            if (this.fork) {
                this.setupWsimportForkCommand();
            } else if (this.cmd.getVmCommand().size() > 1) {
                this.log("JVM args ignored when same JVM is used.", 1);
            }
            this.setupWsimportArgs();
            if (this.fork) {
                int status;
                if (this.verbose) {
                    this.log("command line: wsimport " + this.cmd.toString());
                }
                ok = (status = this.run(this.cmd.getCommandline())) == 0;
            } else {
                if (this.verbose) {
                    this.log("command line: wsimport " + this.cmd.getJavaCommand().toString());
                }
                logstr = new LogOutputStream((Task)this, 1);
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
                Thread.currentThread().setContextClassLoader(loader);
                String sysPath = System.getProperty("java.class.path");
                try {
                    CompileTool compTool = new CompileTool((OutputStream)logstr, "wsimport");
                    if (this.xmlCatalog != null) {
                        compTool.setEntityResolver((EntityResolver)this.xmlCatalog);
                    }
                    if (loader instanceof AntClassLoader) {
                        System.setProperty("java.class.path", ((AntClassLoader)loader).getClasspath());
                    }
                    ok = compTool.run(this.cmd.getJavaCommand().getArguments());
                }
                finally {
                    if (sysPath != null) {
                        System.setProperty("java.class.path", sysPath);
                    }
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            if (!ok) {
                if (!this.verbose) {
                    this.log("Command invoked: wsimport " + this.cmd.toString());
                }
                throw new BuildException("wsimport failed", this.location);
            }
        }
        catch (Exception ex) {
            if (ex instanceof BuildException) {
                throw (BuildException)ex;
            }
            throw new BuildException("Error starting wsimport: ", (Throwable)ex, this.getLocation());
        }
        finally {
            try {
                if (logstr != null) {
                    logstr.close();
                }
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }

    private int run(String[] command) throws BuildException {
        Object fos = null;
        Execute exe = null;
        LogStreamHandler logstr = new LogStreamHandler((Task)this, 2, 1);
        exe = new Execute((ExecuteStreamHandler)logstr);
        exe.setAntRun(this.project);
        exe.setCommandline(command);
        try {
            int rc = exe.execute();
            if (exe.killedProcess()) {
                this.log("Timeout: killed the sub-process", 1);
            }
            return rc;
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e, this.location);
        }
    }
}

