/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.Node;
import org.hsqldb.Trace;

class Index {
    private String sName;
    private int iFields;
    private int[] iColumn;
    private int[] iType;
    private boolean bUnique;
    private Node root;
    private int iColumn_0;
    private int iType_0;
    private static int iNeedCleanUp;

    Index(String name, int[] column, int[] type, boolean unique) {
        this.sName = name;
        this.iFields = column.length;
        this.iColumn = column;
        this.iType = type;
        this.bUnique = unique;
        this.iColumn_0 = this.iColumn[0];
        this.iType_0 = this.iType[0];
    }

    Node getRoot() {
        return this.root;
    }

    void setRoot(Node r) {
        this.root = r;
    }

    String getName() {
        return this.sName;
    }

    boolean isUnique() {
        return this.bUnique;
    }

    int[] getColumns() {
        return this.iColumn;
    }

    void insert(Node i) throws SQLException {
        Node n;
        Object[] data = i.getData();
        Node x = n = this.root;
        boolean way = true;
        int compare = -1;
        while (true) {
            if (n == null) {
                if (x == null) {
                    this.root = i;
                    return;
                }
                break;
            }
            x = n;
            compare = this.compareRow(data, x.getData());
            Trace.check(compare != 0, 8);
            way = compare < 0;
            n = this.child(x, way);
        }
        this.set(x, way, i);
        while (true) {
            int sign = way ? 1 : -1;
            switch (x.getBalance() * sign) {
                case 1: {
                    x.setBalance(0);
                    return;
                }
                case 0: {
                    x.setBalance(-sign);
                    break;
                }
                case -1: {
                    Node l = this.child(x, way);
                    if (l.getBalance() == -sign) {
                        this.replace(x, l);
                        this.set(x, way, this.child(l, !way));
                        this.set(l, !way, x);
                        x.setBalance(0);
                        l.setBalance(0);
                    } else {
                        Node r = this.child(l, !way);
                        this.replace(x, r);
                        this.set(l, !way, this.child(r, way));
                        this.set(r, way, l);
                        this.set(x, way, this.child(r, !way));
                        this.set(r, !way, x);
                        int rb = r.getBalance();
                        x.setBalance(rb == -sign ? sign : 0);
                        l.setBalance(rb == sign ? -sign : 0);
                        r.setBalance(0);
                    }
                    return;
                }
            }
            if (x.equals(this.root)) {
                return;
            }
            way = this.from(x);
            x = x.getParent();
        }
    }

    void delete(Object[] row, boolean datatoo) throws SQLException {
        Node n;
        Node x = this.search(row);
        if (x == null) {
            return;
        }
        if (x.getLeft() == null) {
            n = x.getRight();
        } else if (x.getRight() == null) {
            n = x.getLeft();
        } else {
            Node d = x;
            x = x.getLeft();
            while (x.getRight() != null) {
                x = x.getRight();
            }
            n = x.getLeft();
            int b = x.getBalance();
            x.setBalance(d.getBalance());
            d.setBalance(b);
            Node xp = x.getParent();
            Node dp = d.getParent();
            if (d == this.root) {
                this.root = x;
            }
            x.setParent(dp);
            if (dp != null) {
                if (dp.getRight().equals(d)) {
                    dp.setRight(x);
                } else {
                    dp.setLeft(x);
                }
            }
            if (xp == d) {
                d.setParent(x);
                if (d.getLeft().equals(x)) {
                    x.setLeft(d);
                    x.setRight(d.getRight());
                } else {
                    x.setRight(d);
                    x.setLeft(d.getLeft());
                }
            } else {
                d.setParent(xp);
                xp.setRight(d);
                x.setRight(d.getRight());
                x.setLeft(d.getLeft());
            }
            x.getRight().setParent(x);
            x.getLeft().setParent(x);
            d.setLeft(n);
            if (n != null) {
                n.setParent(d);
            }
            d.setRight(null);
            x = d;
        }
        boolean way = this.from(x);
        this.replace(x, n);
        n = x.getParent();
        x.delete();
        if (datatoo) {
            x.rData.delete();
        }
        while (n != null) {
            x = n;
            int sign = way ? 1 : -1;
            switch (x.getBalance() * sign) {
                case -1: {
                    x.setBalance(0);
                    break;
                }
                case 0: {
                    x.setBalance(sign);
                    return;
                }
                case 1: {
                    Node r = this.child(x, !way);
                    int b = r.getBalance();
                    if (b * sign >= 0) {
                        this.replace(x, r);
                        this.set(x, !way, this.child(r, way));
                        this.set(r, way, x);
                        if (b == 0) {
                            x.setBalance(sign);
                            r.setBalance(-sign);
                            return;
                        }
                        x.setBalance(0);
                        r.setBalance(0);
                        x = r;
                        break;
                    }
                    Node l = this.child(r, way);
                    this.replace(x, l);
                    b = l.getBalance();
                    this.set(r, way, this.child(l, !way));
                    this.set(l, !way, r);
                    this.set(x, !way, this.child(l, way));
                    this.set(l, way, x);
                    x.setBalance(b == sign ? -sign : 0);
                    r.setBalance(b == -sign ? sign : 0);
                    l.setBalance(0);
                    x = l;
                }
            }
            way = this.from(x);
            n = x.getParent();
        }
    }

    Node find(Object[] data) throws SQLException {
        Node x = this.root;
        while (x != null) {
            int i = this.compareRowNonUnique(data, x.getData());
            if (i == 0) {
                return x;
            }
            Node n = i > 0 ? x.getRight() : x.getLeft();
            if (n == null) {
                return null;
            }
            x = n;
        }
        return null;
    }

    Node findFirst(Object value, int compare) throws SQLException {
        Trace.assert(compare == 23 || compare == 21 || compare == 22, "Index.findFirst");
        Node x = this.root;
        int iTest = 1;
        if (compare == 23) {
            iTest = 0;
        }
        while (x != null) {
            boolean t;
            boolean bl = t = this.compareValue(value, x.getData()[this.iColumn_0]) >= iTest;
            if (t) {
                Node r = x.getRight();
                if (r == null) break;
                x = r;
                continue;
            }
            Node l = x.getLeft();
            if (l == null) break;
            x = l;
        }
        while (x != null && this.compareValue(value, x.getData()[this.iColumn_0]) >= iTest) {
            x = this.next(x);
        }
        return x;
    }

    Node first() throws SQLException {
        Node x;
        Node l = x = this.root;
        while (l != null) {
            x = l;
            l = x.getLeft();
        }
        return x;
    }

    Node next(Node x) throws SQLException {
        Node r;
        if ((++iNeedCleanUp & 0x7F) == 0) {
            x.rData.cleanUpCache();
        }
        if ((r = x.getRight()) != null) {
            x = r;
            Node l = x.getLeft();
            while (l != null) {
                x = l;
                l = x.getLeft();
            }
            return x;
        }
        Node ch = x;
        x = x.getParent();
        while (x != null && ch.equals(x.getRight())) {
            ch = x;
            x = x.getParent();
        }
        return x;
    }

    private Node child(Node x, boolean w) throws SQLException {
        return w ? x.getLeft() : x.getRight();
    }

    private void replace(Node x, Node n) throws SQLException {
        if (x.equals(this.root)) {
            this.root = n;
            if (n != null) {
                n.setParent(null);
            }
        } else {
            this.set(x.getParent(), this.from(x), n);
        }
    }

    private void set(Node x, boolean w, Node n) throws SQLException {
        if (w) {
            x.setLeft(n);
        } else {
            x.setRight(n);
        }
        if (n != null) {
            n.setParent(x);
        }
    }

    private boolean from(Node x) throws SQLException {
        if (x.equals(this.root)) {
            return true;
        }
        return x.equals(x.getParent().getLeft());
    }

    private Node search(Object[] d) throws SQLException {
        Node x = this.root;
        while (x != null) {
            int c = this.compareRow(d, x.getData());
            if (c == 0) {
                return x;
            }
            x = c < 0 ? x.getLeft() : x.getRight();
        }
        return null;
    }

    private int compareRowNonUnique(Object[] a, Object[] b) throws SQLException {
        int i = Column.compare(a[this.iColumn_0], b[this.iColumn_0], this.iType_0);
        if (i != 0) {
            return i;
        }
        int j = 1;
        while (j < this.iFields - (this.bUnique ? 0 : 1)) {
            i = Column.compare(a[this.iColumn[j]], b[this.iColumn[j]], this.iType[j]);
            if (i != 0) {
                return i;
            }
            ++j;
        }
        return 0;
    }

    private int compareRow(Object[] a, Object[] b) throws SQLException {
        int i = Column.compare(a[this.iColumn_0], b[this.iColumn_0], this.iType_0);
        if (i != 0) {
            return i;
        }
        int j = 1;
        while (j < this.iFields) {
            i = Column.compare(a[this.iColumn[j]], b[this.iColumn[j]], this.iType[j]);
            if (i != 0) {
                return i;
            }
            ++j;
        }
        return 0;
    }

    private int compareValue(Object a, Object b) throws SQLException {
        return Column.compare(a, b, this.iType_0);
    }
}

