/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import org.hsqldb.CacheFree;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Cache {
    private RandomAccessFile rFile;
    private static final int LENGTH = 16384;
    private static final int MAX_CACHE_SIZE = 12288;
    private Row[] rData;
    private Row[] rWriter;
    private Row rFirst;
    private Row rLastChecked;
    private String sName;
    private static final int MASK = 16383;
    private int iFreePos;
    private static final int FREE_POS_POS = 16;
    private static final int INITIAL_FREE_POS = 32;
    private static final int MAX_FREE_COUNT = 1024;
    private CacheFree fRoot;
    private int iFreeCount;
    private int iCacheSize;

    Cache(String name) {
        this.sName = name;
        this.rData = new Row[16384];
        this.rWriter = new Row[16384];
    }

    void open(boolean readonly) throws SQLException {
        try {
            boolean exists = false;
            File f = new File(this.sName);
            if (f.exists() && f.length() > 16L) {
                exists = true;
            }
            this.rFile = new RandomAccessFile(this.sName, readonly ? "r" : "rw");
            if (exists) {
                this.rFile.seek(16L);
                this.iFreePos = this.rFile.readInt();
            } else {
                this.iFreePos = 32;
            }
        }
        catch (Exception e) {
            throw Trace.error(28, "error " + e + " opening " + this.sName);
        }
    }

    void flush() throws SQLException {
        try {
            this.rFile.seek(16L);
            this.rFile.writeInt(this.iFreePos);
            this.saveAll();
            this.rFile.close();
        }
        catch (Exception e) {
            throw Trace.error(28, "error " + e + " closing " + this.sName);
        }
    }

    void shutdown() throws SQLException {
        try {
            this.rFile.close();
        }
        catch (Exception e) {
            throw Trace.error(28, "error " + e + " in shutdown " + this.sName);
        }
    }

    void free(Row r, int pos, int length) throws SQLException {
        ++this.iFreeCount;
        CacheFree n = new CacheFree();
        n.iPos = pos;
        n.iLength = length;
        if (this.iFreeCount > 1024) {
            this.iFreeCount = 0;
        } else {
            n.fNext = this.fRoot;
        }
        this.fRoot = n;
        this.remove(r);
    }

    void add(Row r) throws SQLException {
        int k;
        Row before;
        int size = r.iSize;
        CacheFree f = this.fRoot;
        CacheFree last = null;
        int i = this.iFreePos;
        while (f != null) {
            if (f.iLength >= size) {
                i = f.iPos;
                if ((size = f.iLength - size) < 8) {
                    if (last == null) {
                        this.fRoot = f.fNext;
                    } else {
                        last.fNext = f.fNext;
                    }
                    --this.iFreeCount;
                    break;
                }
                f.iLength = size;
                f.iPos += r.iSize;
                break;
            }
            last = f;
            f = f.fNext;
        }
        r.iPos = i;
        if (i == this.iFreePos) {
            this.iFreePos += size;
        }
        if ((before = this.rData[k = i & 0x3FFF]) == null) {
            before = this.rFirst;
        }
        r.insert(before);
        ++this.iCacheSize;
        this.rData[k] = r;
        this.rFirst = r;
    }

    Row getRow(int pos, Table t) throws SQLException {
        Row before;
        Row r;
        int k = pos & 0x3FFF;
        Row start = r = this.rData[k];
        while (r != null) {
            int p = r.iPos;
            if (p == pos) {
                return r;
            }
            if ((p & 0x3FFF) != k || (r = r.rNext) == start) break;
        }
        if ((before = this.rData[k]) == null) {
            before = this.rFirst;
        }
        try {
            this.rFile.seek(pos);
            int size = this.rFile.readInt();
            byte[] buffer = new byte[size];
            this.rFile.read(buffer);
            ByteArrayInputStream bin = new ByteArrayInputStream(buffer);
            DataInputStream in = new DataInputStream(bin);
            r = new Row(t, in, pos, before);
            r.iSize = size;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw Trace.error(28, "reading: " + e);
        }
        ++this.iCacheSize;
        this.rData[k] = r;
        this.rFirst = r;
        return r;
    }

    void cleanUp() throws SQLException {
        if (this.iCacheSize < 12288) {
            return;
        }
        int count = 0;
        int j = 0;
        while (j++ < 16384 && this.iCacheSize + 16384 > 12288 && count * 16 < 16384) {
            Row r = this.getWorst();
            if (r == null) {
                return;
            }
            if (r.bChanged) {
                this.rWriter[count++] = r;
                continue;
            }
            if (r.canRemove()) continue;
            this.remove(r);
        }
        if (count != 0) {
            this.saveSorted(count);
        }
        int i = 0;
        while (i < count) {
            Row r = this.rWriter[i];
            if (!r.canRemove()) {
                this.remove(r);
            }
            this.rWriter[i] = null;
            ++i;
        }
    }

    private void remove(Row r) throws SQLException {
        int k;
        if (r == this.rLastChecked) {
            this.rLastChecked = this.rLastChecked.rNext;
            if (this.rLastChecked == r) {
                this.rLastChecked = null;
            }
        }
        if (this.rData[k = r.iPos & 0x3FFF] == r) {
            Row n;
            this.rFirst = n = r.rNext;
            if (n == r || (n.iPos & 0x3FFF) != k) {
                n = null;
            }
            this.rData[k] = n;
        }
        if (r == this.rFirst) {
            this.rFirst = this.rFirst.rNext;
            if (r == this.rFirst) {
                this.rFirst = null;
            }
        }
        r.free();
        --this.iCacheSize;
    }

    private Row getWorst() throws SQLException {
        Row r;
        if (this.rLastChecked == null) {
            this.rLastChecked = this.rFirst;
        }
        if ((r = this.rLastChecked) == null) {
            return null;
        }
        Row candidate = r;
        int worst = Row.iCurrentAccess;
        int i = 0;
        while (i < 6) {
            int w = r.iLastAccess;
            if (w < worst) {
                candidate = r;
                worst = w;
            }
            r = r.rNext;
            ++i;
        }
        this.rLastChecked = r.rNext;
        return candidate;
    }

    private void saveAll() throws SQLException {
        if (this.rFirst == null) {
            return;
        }
        Row r = this.rFirst;
        block0: while (true) {
            int count = 0;
            Row begin = r;
            do {
                if (!r.bChanged) continue;
                this.rWriter[count++] = r;
            } while ((r = r.rNext) != begin && count < 16384);
            if (count == 0) {
                return;
            }
            this.saveSorted(count);
            int i = 0;
            while (true) {
                if (i >= count) continue block0;
                this.rWriter[i] = null;
                ++i;
            }
            break;
        }
    }

    private void saveSorted(int count) throws SQLException {
        Cache.sort(this.rWriter, 0, count - 1);
        try {
            int i = 0;
            while (i < count) {
                this.rFile.seek(this.rWriter[i].iPos);
                this.rFile.write(this.rWriter[i].write());
                ++i;
            }
        }
        catch (Exception e) {
            throw Trace.error(28, "saveSorted " + e);
        }
    }

    private static final void sort(Row[] w, int l, int r) throws SQLException {
        int j;
        int i;
        while (r - l > 10) {
            i = r + l >> 1;
            if (w[l].iPos > w[r].iPos) {
                Cache.swap(w, l, r);
            }
            if (w[i].iPos < w[l].iPos) {
                Cache.swap(w, l, i);
            } else if (w[i].iPos > w[r].iPos) {
                Cache.swap(w, i, r);
            }
            j = r - 1;
            Cache.swap(w, i, j);
            int p = w[j].iPos;
            i = l;
            while (true) {
                if (w[++i].iPos < p) {
                    continue;
                }
                while (w[--j].iPos > p) {
                }
                if (i >= j) break;
                Cache.swap(w, i, j);
            }
            Cache.swap(w, i, r - 1);
            Cache.sort(w, l, i - 1);
            l = i + 1;
        }
        i = l + 1;
        while (i <= r) {
            Row t = w[i];
            j = i - 1;
            while (j >= l && w[j].iPos > t.iPos) {
                w[j + 1] = w[j];
                --j;
            }
            w[j + 1] = t;
            ++i;
        }
    }

    private static void swap(Row[] w, int a, int b) {
        Row t = w[a];
        w[a] = w[b];
        w[b] = t;
    }
}

