/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Vector;
import org.hsqldb.Trace;
import org.hsqldb.User;

class Access {
    static final int SELECT = 1;
    static final int DELETE = 2;
    static final int INSERT = 4;
    static final int UPDATE = 8;
    static final int ALL = 15;
    private Vector uUser = new Vector();
    private User uPublic = this.createUser("PUBLIC", null, false);

    Access() throws SQLException {
    }

    static int getRight(String right) throws SQLException {
        if (right.equals("ALL")) {
            return 15;
        }
        if (right.equals("SELECT")) {
            return 1;
        }
        if (right.equals("UPDATE")) {
            return 8;
        }
        if (right.equals("DELETE")) {
            return 2;
        }
        if (right.equals("INSERT")) {
            return 4;
        }
        throw Trace.error(10, right);
    }

    static String getRight(int right) {
        if (right == 15) {
            return "ALL";
        }
        if (right == 0) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        if ((right & 1) != 0) {
            b.append("SELECT,");
        }
        if ((right & 8) != 0) {
            b.append("UPDATE,");
        }
        if ((right & 2) != 0) {
            b.append("DELETE,");
        }
        if ((right & 4) != 0) {
            b.append("INSERT,");
        }
        String s = b.toString();
        return s.substring(0, s.length() - 1);
    }

    User createUser(String name, String password, boolean admin) throws SQLException {
        User u;
        int i = 0;
        while (i < this.uUser.size()) {
            u = (User)this.uUser.elementAt(i);
            if (u != null && u.getName().equals(name)) {
                throw Trace.error(34, name);
            }
            ++i;
        }
        u = new User(name, password, admin, this.uPublic);
        this.uUser.addElement(u);
        return u;
    }

    void dropUser(String name) throws SQLException {
        Trace.check(!name.equals("PUBLIC"), 31);
        int i = 0;
        while (i < this.uUser.size()) {
            User u = (User)this.uUser.elementAt(i);
            if (u != null && u.getName().equals(name)) {
                this.uUser.setElementAt(null, i);
                u.revokeAll();
                return;
            }
            ++i;
        }
        throw Trace.error(35, name);
    }

    User getUser(String name, String password) throws SQLException {
        Trace.check(!name.equals("PUBLIC"), 31);
        if (name == null) {
            name = "";
        }
        if (password == null) {
            password = "";
        }
        User u = this.get(name);
        u.checkPassword(password);
        return u;
    }

    Vector getUsers() {
        return this.uUser;
    }

    void grant(String name, String object, int right) throws SQLException {
        this.get(name).grant(object, right);
    }

    void revoke(String name, String object, int right) throws SQLException {
        this.get(name).revoke(object, right);
    }

    private User get(String name) throws SQLException {
        int i = 0;
        while (i < this.uUser.size()) {
            User u = (User)this.uUser.elementAt(i);
            if (u != null && u.getName().equals(name)) {
                return u;
            }
            ++i;
        }
        throw Trace.error(35, name);
    }
}

