/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.tools;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.bpel.xml.ProblemCounter;
import org.jbpm.bpel.xml.ProblemHandler;
import org.jbpm.jpdl.xml.Problem;

public class ProcessDeployer {
    private String host = "localhost";
    private int port = 8080;
    private String context = "/jbpm-bpel/deploy";
    private ProblemHandler problemHandler = new ProblemCounter();
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jbpm.bpel.tools.ProcessDeployer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        if (host == null) {
            throw new IllegalArgumentException("host cannot be null");
        }
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port < -1) {
            throw new IllegalArgumentException("invalid port: " + port);
        }
        this.port = port;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.context = context;
    }

    public ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    public void setProblemHandler(ProblemHandler problemHandler) {
        this.problemHandler = problemHandler;
    }

    public void deployProcess(File processFile) {
        URL deployUrl;
        if (processFile == null) {
            throw new IllegalArgumentException("process file cannot be null");
        }
        if (!processFile.exists()) {
            this.problemHandler.add(new Problem(2, "process file not found: " + processFile));
            return;
        }
        try {
            deployUrl = this.formatDeployRequest(this.getProcessLocation(processFile));
        }
        catch (MalformedURLException e) {
            this.problemHandler.add(new Problem(2, "cannot format a valid url from the given host, port and context", (Throwable)e));
            return;
        }
        try {
            this.connectTo(deployUrl);
        }
        catch (IOException e) {
            this.problemHandler.add(new Problem(2, "cannot connect to deployment url", (Throwable)e));
            return;
        }
    }

    private String getProcessLocation(File processFile) {
        URI processLocation = processFile.toURI();
        try {
            processLocation = new URI(processLocation.getScheme(), "", processLocation.getPath(), null);
            log.info((Object)("process location: " + processLocation));
        }
        catch (URISyntaxException e) {
            this.problemHandler.add(new Problem(3, "could not add host component to process location URI, leaving host undefined", (Throwable)e));
        }
        return processLocation.toString();
    }

    private URL formatDeployRequest(String processLocation) throws MalformedURLException {
        try {
            processLocation = URLEncoder.encode(processLocation, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.problemHandler.add(new Problem(3, "UTF-8 encoding not supported, process location will be sent decoded", (Throwable)e));
        }
        String file = String.valueOf(this.context) + "?processfile=" + processLocation;
        URL deployUrl = new URL("http", this.host, this.port, file);
        log.info((Object)("deployment url: " + deployUrl));
        return deployUrl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectTo(URL deployUrl) throws IOException {
        HttpURLConnection httpConnection = (HttpURLConnection)deployUrl.openConnection();
        try {
            httpConnection.connect();
            int responseCode = httpConnection.getResponseCode();
            log.info((Object)("response code: " + responseCode));
            if (responseCode != 200) {
                this.problemHandler.add(new Problem(2, "deployment failed, see details in the server log file"));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            httpConnection.disconnect();
            throw throwable;
        }
        {
            Object var4_6 = null;
            httpConnection.disconnect();
            return;
        }
    }
}

