/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.junitee.anttask.AbstractResultFormatter;
import org.junitee.anttask.JUnitEEResultFormatter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SummaryResultFormatter
extends AbstractResultFormatter
implements JUnitEEResultFormatter {
    private OutputStreamWriter writer;

    public void format(Node testNode) throws IOException {
        NamedNodeMap attributes = testNode.getAttributes();
        String testName = this.getTestName(testNode);
        String runs = attributes.getNamedItem("tests").getNodeValue();
        int errors = Integer.parseInt(attributes.getNamedItem("errors").getNodeValue());
        int failures = Integer.parseInt(attributes.getNamedItem("failures").getNodeValue());
        String time = attributes.getNamedItem("time").getNodeValue();
        StringBuffer buffer = new StringBuffer();
        buffer.append(testName).append(" (runs: ").append(runs).append(" errors: ").append(errors);
        buffer.append(" failures: ").append(failures).append(" time: ").append(time).append(" sec)\n");
        if (errors == 0 && failures == 0) {
            buffer.append("Test successful");
        } else {
            buffer.append("TEST FAILED");
        }
        if (this.getWriter(testName) == null) {
            return;
        }
        this.getWriter(testName).write(buffer.toString());
        this.getWriter(testName).write("\n\n");
    }

    public void flush() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        super.flush();
    }

    private OutputStreamWriter getWriter(String testName) throws FileNotFoundException {
        if (this.getOutput(testName) == null) {
            return null;
        }
        if (this.writer == null) {
            this.writer = new OutputStreamWriter(this.getOutput(testName));
        }
        return this.writer;
    }
}

