/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.junitee.anttask.FormatterElement;
import org.junitee.anttask.JUnitEEResultFormatter;
import org.junitee.anttask.JUnitEETest;
import org.junitee.anttask.SummaryResultFormatter;
import org.xml.sax.SAXException;

public class JUnitEETask
extends Task {
    private String url;
    private Vector tests = new Vector();
    private boolean printSummary = false;
    private Vector formatters = new Vector();

    public void setUrl(String url) {
        this.url = url;
    }

    public void setFiltertrace(boolean filtertrace) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setFiltertrace(filtertrace);
        }
    }

    public void setHaltonfailure(boolean value) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setHaltonfailure(value);
        }
    }

    public void setHaltonerror(boolean value) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setHaltonerror(value);
        }
    }

    public void setPrintsummary(boolean printSummary) {
        this.printSummary = printSummary;
    }

    public void setErrorproperty(String value) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setErrorproperty(value);
        }
    }

    public void setFailureproperty(String value) {
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            ((JUnitEETest)enumeration.nextElement()).setFailureproperty(value);
        }
    }

    public JUnitEETest createTest() {
        JUnitEETest test = new JUnitEETest();
        this.tests.add(test);
        return test;
    }

    public void addFormatter(FormatterElement formatter) {
        this.formatters.addElement(formatter);
    }

    public void execute() throws BuildException {
        if (this.url == null) {
            throw new BuildException("You must specify the url attribute", this.location);
        }
        try {
            new URL(this.url);
        }
        catch (MalformedURLException e) {
            throw new BuildException(this.url + " is no valid URL");
        }
        Enumeration enumeration = this.tests.elements();
        while (enumeration.hasMoreElements()) {
            JUnitEETest test = (JUnitEETest)enumeration.nextElement();
            if (!test.shouldExecute(this.getProject())) continue;
            this.execute(test);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void execute(JUnitEETest test) throws BuildException {
        arguments = new StringBuffer();
        arguments.append(this.url).append("?output=xml&thread=true");
        if (test.getResource() != null) {
            arguments.append("&resource=").append(test.getResource());
        }
        if (test.getRunall()) {
            arguments.append("&all=true");
        } else if (test.getName() != null) {
            arguments.append("&suite=").append(URLEncoder.encode(test.getName()));
        } else {
            throw new BuildException("You must specify the test name or runall attribute", this.location);
        }
        if (!test.getFiltertrace()) {
            arguments.append("&filterTrace=false");
        }
        try {
            url = new URL(arguments.toString());
            con = url.openConnection();
            sessionCookie = con.getHeaderField("Set-Cookie");
            this.log("Session cookie : " + sessionCookie, 4);
            done = this.parseResult(con.getInputStream(), test);
            if (true) ** GOTO lbl50
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            this.log("Failed to execute test: " + e, 0);
            throw new BuildException((Throwable)e);
        }
        do {
            try {
                this.log("Sleeping ... ", 4);
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                this.log("Get xml again", 4);
                url = new URL(e + "?output=xml");
                con = url.openConnection();
                con.setRequestProperty("Cookie", sessionCookie);
                done = this.parseResult(con.getInputStream(), test);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                this.log("Failed to execute test: " + e, 0);
                throw new BuildException((Throwable)e);
            }
lbl50:
            // 2 sources

        } while (!done);
    }

    /*
     * Unable to fully structure code
     */
    private boolean parseResult(InputStream in, JUnitEETest test) throws Exception {
        block17: {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
            buffer = this.readInput(in);
            try {
                document = builder.parse(new ByteArrayInputStream(buffer));
            }
            catch (SAXException e) {
                this.log("Invalid xml:\n " + new String(buffer), 0);
                throw new BuildException("Unable to parse test result (no valid xml).");
            }
            root = document.getDocumentElement();
            if (root.getAttributeNode("unfinished") != null) {
                this.log(String.valueOf(root.getAttributeNode("unfinished")), 4);
                return false;
            }
            root.normalize();
            testcases = root.getElementsByTagName("testsuite");
            resultFormatters = this.createFormatters(test);
            try {
                i = 0;
                while (i < testcases.getLength()) {
                    node = testcases.item(i);
                    attributes = node.getAttributes();
                    testClass = attributes.getNamedItem("name").getNodeValue();
                    testPkg = attributes.getNamedItem("package").getNodeValue();
                    errors = Integer.parseInt(attributes.getNamedItem("errors").getNodeValue());
                    failures = Integer.parseInt(attributes.getNamedItem("failures").getNodeValue());
                    testName = testPkg != null && testPkg.length() != 0 ? testPkg + "." + testClass : testClass;
                    enumeration = resultFormatters.elements();
                    while (enumeration.hasMoreElements()) {
                        formatter = (JUnitEEResultFormatter)enumeration.nextElement();
                        this.log("Calling formatter " + formatter + " for node " + node, 4);
                        formatter.format(node);
                    }
                    if (errors != 0) {
                        if (test.getErrorproperty() != null) {
                            this.getProject().setNewProperty(test.getErrorproperty(), "true");
                        }
                        if (test.getHaltonerror() || test.getHaltonfailure()) {
                            throw new BuildException("Test " + testName + " failed.");
                        }
                    }
                    if (failures != 0) {
                        if (test.getFailureproperty() != null) {
                            this.getProject().setNewProperty(test.getFailureproperty(), "true");
                        }
                        if (test.getHaltonfailure()) {
                            throw new BuildException("Test " + testName + " failed.");
                        }
                    }
                    ++i;
                }
                var21_23 = null;
                enumeration = resultFormatters.elements();
                ** while (enumeration.hasMoreElements())
            }
            catch (Throwable var20_29) {
                var21_24 = null;
                enumeration = resultFormatters.elements();
                ** while (enumeration.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                formatter = (JUnitEEResultFormatter)enumeration.nextElement();
                formatter.flush();
                continue;
lbl51:
                // 1 sources

                break block17;
            }
lbl-1000:
            // 1 sources

            {
                formatter = (JUnitEEResultFormatter)enumeration.nextElement();
                formatter.flush();
                continue;
            }
lbl60:
            // 1 sources

            throw var20_29;
        }
        errorMessages = root.getElementsByTagName("errorMessage");
        i = 0;
        while (i < errorMessages.getLength()) {
            message = errorMessages.item(i);
            this.log(message.getFirstChild().getNodeValue(), 0);
            ++i;
        }
        if (errorMessages.getLength() != 0) {
            throw new BuildException("Test execution failed.");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readInput(InputStream in) throws IOException {
        int r;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((r = in.read(buffer)) != -1) {
            void var3_4;
            out.write(buffer, 0, (int)var3_4);
        }
        return out.toByteArray();
    }

    private Vector createFormatters(JUnitEETest test) {
        FormatterElement element;
        Vector<JUnitEEResultFormatter> answer = new Vector<JUnitEEResultFormatter>();
        Enumeration enumeration = this.formatters.elements();
        while (enumeration.hasMoreElements()) {
            element = (FormatterElement)enumeration.nextElement();
            element.setOutFile(test.getOutfile());
            element.setFilterTrace(test.getFiltertrace());
            answer.add(element.createFormatter());
        }
        enumeration = test.getFormatters();
        while (enumeration.hasMoreElements()) {
            element = (FormatterElement)enumeration.nextElement();
            element.setOutFile(test.getOutfile());
            element.setFilterTrace(test.getFiltertrace());
            answer.add(element.createFormatter());
        }
        if (this.printSummary) {
            this.log("Adding summary formatter", 4);
            SummaryResultFormatter summary = new SummaryResultFormatter();
            summary.setOut(System.out);
            answer.add(summary);
        }
        this.log("Formatters: " + answer, 4);
        return answer;
    }

    protected File getOutput(FormatterElement formatter, JUnitEETest test) {
        if (formatter.isUseFile()) {
            String filename = test.getOutfile() + formatter.getExtension();
            File destFile = new File(test.getTodir(), filename);
            String absFilename = destFile.getAbsolutePath();
            return this.getProject().resolveFile(absFilename);
        }
        return null;
    }
}

