/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.anttask;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.junitee.anttask.JUnitEEResultFormatter;

public class FormatterElement {
    private String classname;
    private boolean useFile = true;
    private File outFile;
    private String extension;
    private boolean filterTrace;

    public void setType(String type) {
        if ("xml".equals(type)) {
            this.setClassname("org.junitee.anttask.XMLResultFormatter");
            this.setExtension(".xml");
        } else if ("plain".equals(type)) {
            this.setClassname("org.junitee.anttask.PlainResultFormatter");
            this.setExtension(".txt");
        } else if ("brief".equals(type)) {
            this.setClassname("org.junitee.anttask.BriefResultFormatter");
            this.setExtension(".txt");
        } else {
            throw new BuildException("Unknown formatter type '" + type + "'");
        }
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public boolean isUseFile() {
        return this.useFile;
    }

    public void setUseFile(boolean useFile) {
        this.useFile = useFile;
    }

    public File getOutFile() {
        return this.outFile;
    }

    public void setOutFile(File outFile) {
        this.outFile = outFile;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public JUnitEEResultFormatter createFormatter() throws BuildException {
        if (this.getClassname() == null) {
            throw new BuildException("you must specify type or classname");
        }
        try {
            Class<?> clazz = Class.forName(this.getClassname());
            Object instance = clazz.newInstance();
            if (instance instanceof JUnitEEResultFormatter) {
                JUnitEEResultFormatter formatter = (JUnitEEResultFormatter)instance;
                if (this.isUseFile() && this.getOutFile() != null) {
                    formatter.setOutfile(this.getOutFile());
                    formatter.setExtension(this.getExtension());
                    formatter.setFilterTrace(this.filterTrace);
                } else {
                    formatter.setOut(System.out);
                }
                return formatter;
            }
            throw new BuildException(this.getClassname() + " does not implement JUnitEEResultFormatter");
        }
        catch (ClassNotFoundException e) {
            throw new BuildException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setFilterTrace(boolean filtertrace) {
        this.filterTrace = filtertrace;
    }
}

