/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.InvocationContext;
import com.meterware.servletunit.InvocationContextFactory;
import com.meterware.servletunit.InvocationContextImpl;
import com.meterware.servletunit.ServletUnitClient;
import com.meterware.servletunit.ServletUnitContext;
import com.meterware.servletunit.WebApplication;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Dictionary;
import javax.servlet.http.Cookie;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ServletRunner {
    WebApplication _application;
    private ServletUnitClient _client;
    private ServletUnitContext _context;
    private InvocationContextFactory _factory = new InvocationContextFactory(){

        public InvocationContext newInvocation(WebRequest request, Cookie[] clientCookies, Dictionary clientHeaders, byte[] messageBody) throws IOException, MalformedURLException {
            return new InvocationContextImpl(ServletRunner.this, request, clientCookies, clientHeaders, messageBody);
        }
    };

    public ServletRunner() {
        this._context = new ServletUnitContext();
        this._application = new WebApplication();
    }

    public ServletRunner(String webXMLFileSpec) throws IOException, SAXException {
        this._context = new ServletUnitContext();
        this._application = new WebApplication(HttpUnitUtils.newParser().parse(webXMLFileSpec));
    }

    public ServletRunner(String webXMLFileSpec, String contextPath) throws IOException, SAXException {
        this._context = new ServletUnitContext(contextPath);
        File webXMLFile = new File(webXMLFileSpec);
        this._application = new WebApplication(HttpUnitUtils.newParser().parse(webXMLFileSpec), webXMLFile.getParentFile().getParentFile(), this._context.getContextPath());
    }

    public ServletRunner(InputStream webXML) throws IOException, SAXException {
        this(webXML, null);
    }

    public ServletRunner(InputStream webXML, String contextPath) throws IOException, SAXException {
        this._context = new ServletUnitContext(contextPath);
        this._application = new WebApplication(HttpUnitUtils.newParser().parse(new InputSource(webXML)), this._context.getContextPath());
    }

    public void registerServlet(String resourceName, String servletClassName) {
        this._application.registerServlet(resourceName, servletClassName);
    }

    public WebResponse getResponse(WebRequest request) throws MalformedURLException, IOException, SAXException {
        return this.getClient().getResponse(request);
    }

    public WebResponse getResponse(String url) throws MalformedURLException, IOException, SAXException {
        return this.getClient().getResponse(url);
    }

    public ServletUnitClient newClient() {
        return ServletUnitClient.newClient(this._factory);
    }

    ServletUnitContext getContext() {
        return this._context;
    }

    private ServletUnitClient getClient() {
        if (this._client == null) {
            this._client = this.newClient();
        }
        return this._client;
    }
}

