/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.ByteTag;
import com.meterware.httpunit.ByteTagParser;
import com.meterware.httpunit.DefaultWebResponse;
import com.meterware.httpunit.FrameHolder;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HTMLSegment;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.HttpWebResponse;
import com.meterware.httpunit.NoSuchFrameException;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.NotHTMLException;
import com.meterware.httpunit.ReceivedPage;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebFrame;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebResponse
implements HTMLSegment {
    static final WebResponse BLANK_RESPONSE = new DefaultWebResponse("<html><head></head><body></body></html>");
    private static final int IETF_RFC2109 = 0;
    private static final int IETF_RFC2965 = 1;
    private static final String HTML_CONTENT = "text/html";
    private static final int UNINITIALIZED_INT = -2;
    private WebFrame[] _frames;
    private ReceivedPage _page;
    private String _contentHeader;
    private int _contentLength = -2;
    private String _contentType;
    private String _characterSet;
    private Hashtable _newCookies;
    private WebRequest _refreshRequest;
    private FrameHolder _frameHolder;
    private int _refreshDelay;
    private String _responseText;
    private InputStream _inputStream;
    private URL _url;
    private String _frameName;
    private static String _defaultEncoding;
    private static final String[] DEFAULT_ENCODING_CANDIDATES;

    public static WebResponse newResponse(URLConnection connection) throws IOException {
        return new HttpWebResponse("_top", connection.getURL(), connection, HttpUnitOptions.getExceptionsThrownOnErrorStatus());
    }

    public boolean isHTML() {
        return this.getContentType().equals(HTML_CONTENT);
    }

    public URL getURL() {
        return this._url;
    }

    public String getTitle() throws SAXException {
        return this.getReceivedPage().getTitle();
    }

    public String getExternalStyleSheet() throws SAXException {
        return this.getReceivedPage().getExternalStyleSheet();
    }

    public String[] getMetaTagContent(String attribute, String attributeValue) throws SAXException {
        return this.getReceivedPage().getMetaTagContent(attribute, attributeValue);
    }

    public String getTarget() {
        return this._frameName;
    }

    public WebRequest getRefreshRequest() {
        return this._refreshRequest;
    }

    public int getRefreshDelay() {
        return this._refreshDelay;
    }

    public abstract int getResponseCode();

    public abstract String getResponseMessage();

    public int getContentLength() {
        if (this._contentLength == -2) {
            String length = this.getHeaderField("Content-Length");
            this._contentLength = length == null ? -1 : Integer.parseInt(length);
        }
        return this._contentLength;
    }

    public String getContentType() {
        if (this._contentType == null) {
            this.readContentTypeHeader();
        }
        return this._contentType;
    }

    public String getCharacterSet() {
        if (this._characterSet == null) {
            this.readContentTypeHeader();
            if (this._characterSet == null) {
                this._characterSet = this.getHeaderField("Charset");
            }
            if (this._characterSet == null) {
                this._characterSet = HttpUnitOptions.getDefaultCharacterSet();
            }
            try {
                "abcd".getBytes(this._characterSet);
            }
            catch (UnsupportedEncodingException e) {
                this._characterSet = WebResponse.getDefaultEncoding();
            }
        }
        return this._characterSet;
    }

    public String[] getNewCookieNames() {
        String[] names = new String[this.getNewCookies().size()];
        int i = 0;
        Enumeration e = this.getNewCookies().keys();
        while (e.hasMoreElements()) {
            names[i] = (String)e.nextElement();
            ++i;
        }
        return names;
    }

    public String getNewCookieValue(String name) {
        return (String)this.getNewCookies().get(name);
    }

    public abstract String[] getHeaderFieldNames();

    public abstract String getHeaderField(String var1);

    public abstract String[] getHeaderFields(String var1);

    public String getText() throws IOException {
        if (this._responseText == null) {
            this.loadResponseText();
        }
        return this._responseText;
    }

    public InputStream getInputStream() throws IOException {
        if (this._inputStream == null) {
            this._inputStream = new ByteArrayInputStream(new byte[0]);
        }
        return this._inputStream;
    }

    public String[] getFrameNames() throws SAXException {
        WebFrame[] frames = this.getFrames();
        String[] result = new String[frames.length];
        int i = 0;
        while (i < result.length) {
            result[i] = frames[i].getName();
            ++i;
        }
        return result;
    }

    public WebResponse getSubframeContents(String subFrameName) {
        if (this._frameHolder == null) {
            throw new NoSuchFrameException(subFrameName);
        }
        return this._frameHolder.getFrameContents(WebFrame.getNestedFrameName(this._frameName, subFrameName));
    }

    public WebForm[] getForms() throws SAXException {
        return this.getReceivedPage().getForms();
    }

    public WebForm getFormWithName(String name) throws SAXException {
        return this.getReceivedPage().getFormWithName(name);
    }

    public WebForm getFormWithID(String ID) throws SAXException {
        return this.getReceivedPage().getFormWithID(ID);
    }

    public WebLink[] getLinks() throws SAXException {
        return this.getReceivedPage().getLinks();
    }

    public WebLink getLinkWith(String text) throws SAXException {
        return this.getReceivedPage().getLinkWith(text);
    }

    public WebLink getLinkWithImageText(String text) throws SAXException {
        return this.getReceivedPage().getLinkWithImageText(text);
    }

    public WebLink getLinkWithName(String name) throws SAXException {
        return this.getReceivedPage().getLinkWithName(name);
    }

    public WebLink getLinkWithID(String ID) throws SAXException {
        return this.getReceivedPage().getLinkWithID(ID);
    }

    public WebTable[] getTables() throws SAXException {
        return this.getReceivedPage().getTables();
    }

    public Document getDOM() throws SAXException {
        if (this.isHTML()) {
            return (Document)this.getReceivedPage().getDOM();
        }
        try {
            return HttpUnitUtils.newParser().parse(new InputSource(new StringReader(this.getText())));
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    public WebTable getTableStartingWith(String text) throws SAXException {
        return this.getReceivedPage().getTableStartingWith(text);
    }

    public WebTable getTableStartingWithPrefix(String text) throws SAXException {
        return this.getReceivedPage().getTableStartingWithPrefix(text);
    }

    public WebTable getTableWithSummary(String text) throws SAXException {
        return this.getReceivedPage().getTableWithSummary(text);
    }

    public WebTable getTableWithID(String text) throws SAXException {
        return this.getReceivedPage().getTableWithID(text);
    }

    public abstract String toString();

    protected WebResponse(String frameName, URL url) {
        this._url = url;
        this._frameName = frameName;
    }

    protected final void defineRawInputStream(InputStream inputStream) throws IOException {
        if (this._inputStream != null || this._responseText != null) {
            throw new IllegalStateException("Must be called before response text is defined.");
        }
        this._inputStream = this.encodedUsingGZIP() ? new GZIPInputStream(inputStream) : inputStream;
    }

    private boolean encodedUsingGZIP() {
        String encoding = this.getHeaderField("Content-Encoding");
        return encoding != null && encoding.indexOf("gzip") >= 0;
    }

    protected final void readRefreshRequest(String contentTypeHeader) {
        int splitIndex = contentTypeHeader.indexOf(59);
        if (splitIndex < 0) {
            splitIndex = 0;
        }
        try {
            this._refreshDelay = Integer.parseInt(contentTypeHeader.substring(0, splitIndex));
            this._refreshRequest = new GetMethodWebRequest(this._url, this.getRefreshURL(contentTypeHeader.substring(splitIndex + 1)), this._frameName);
        }
        catch (NumberFormatException e) {
            System.out.println("Unable to interpret refresh tag: \"" + contentTypeHeader + '\"');
        }
    }

    private String getRefreshURL(String text) {
        if (!(text = text.trim()).toUpperCase().startsWith("URL")) {
            return text;
        }
        int splitIndex = text.indexOf(61);
        return text.substring(splitIndex + 1).trim();
    }

    protected void setContentTypeHeader(String value) {
        this._contentHeader = value;
    }

    WebRequest[] getFrameRequests() throws SAXException {
        WebFrame[] frames = this.getFrames();
        Vector<WebRequest> requests = new Vector<WebRequest>();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].hasInitialRequest()) {
                requests.addElement(frames[i].getInitialRequest());
            }
            ++i;
        }
        Object[] result = new WebRequest[requests.size()];
        requests.copyInto(result);
        return result;
    }

    void setFrameHolder(FrameHolder holder) {
        this._frameHolder = holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadResponseText() throws IOException {
        if (this._responseText != null) {
            throw new IllegalStateException("May only invoke loadResponseText once");
        }
        this._responseText = "";
        InputStream inputStream = this.getInputStream();
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                outputStream.write(buffer, 0, count);
            } while ((count = inputStream.read(buffer, 0, buffer.length)) != -1);
            byte[] bytes = outputStream.toByteArray();
            this.readMetaTags(bytes);
            this._responseText = new String(bytes, this.getCharacterSet());
            this._inputStream = new ByteArrayInputStream(bytes);
            if (HttpUnitOptions.isCheckContentLength() && this.getContentLength() >= 0 && bytes.length != this.getContentLength()) {
                throw new IOException("Truncated message. Expected length: " + this.getContentLength() + ", Actual length: " + bytes.length);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    private void readMetaTags(byte[] rawMessage) throws UnsupportedEncodingException {
        ByteTagParser parser = new ByteTagParser(rawMessage);
        ByteTag tag = parser.getNextTag();
        while (tag != null && !tag.getName().equalsIgnoreCase("body")) {
            if (tag.getName().equalsIgnoreCase("meta")) {
                this.processMetaTag(tag);
            }
            tag = parser.getNextTag();
        }
    }

    private void processMetaTag(ByteTag tag) {
        if (this.isHttpEquivMetaTag(tag, "content-type")) {
            this.inferContentType(tag.getAttribute("content"));
        } else if (this.isHttpEquivMetaTag(tag, "refresh")) {
            this.readRefreshRequest(tag.getAttribute("content"));
        }
    }

    private boolean isHttpEquivMetaTag(ByteTag tag, String headerName) {
        return headerName.equalsIgnoreCase(tag.getAttribute("http_equiv")) || headerName.equalsIgnoreCase(tag.getAttribute("http-equiv"));
    }

    private void inferContentType(String contentTypeHeader) {
        String originalHeader = this.getHeaderField("Content-type");
        if (originalHeader == null || originalHeader.indexOf("charset") < 0) {
            this.setContentTypeHeader(contentTypeHeader);
        }
    }

    private Hashtable getNewCookies() {
        if (this._newCookies == null) {
            this._newCookies = new Hashtable();
        }
        this.processCookieHeaders(this.getHeaderFields("Set-Cookie"), 0);
        this.processCookieHeaders(this.getHeaderFields("Set-Cookie2"), 1);
        return this._newCookies;
    }

    private void processCookieHeaders(String[] cookieHeader, int version) {
        int i = 0;
        while (i < cookieHeader.length) {
            this.processCookieHeader(cookieHeader[i], version);
            ++i;
        }
    }

    private void processCookieHeader(String cookieHeader, int version) {
        Vector tokens = this.getCookieTokens(cookieHeader);
        String tokensToAdd = "";
        int i = tokens.size() - 1;
        while (i >= 0) {
            String token = (String)tokens.elementAt(i);
            int equalsIndex = this.getEqualsIndex(token);
            if (equalsIndex != -1) {
                String name = token.substring(0, equalsIndex).trim();
                if (!this.isCookieAttribute(name, version)) {
                    String value = token.substring(equalsIndex + 1).trim();
                    this._newCookies.put(name, value + tokensToAdd);
                }
                tokensToAdd = "";
            } else if (this.isCookieReservedWord(token, version)) {
                tokensToAdd = "";
            } else {
                String preceedingToken;
                char lastChar;
                tokensToAdd = token + tokensToAdd;
                if (i > 0 && (lastChar = (preceedingToken = (String)tokens.elementAt(i - 1)).charAt(preceedingToken.length() - 1)) != '=') {
                    tokensToAdd = "," + tokensToAdd;
                }
            }
            --i;
        }
    }

    private int getEqualsIndex(String token) {
        if (!token.endsWith("==")) {
            return token.indexOf(61);
        }
        return this.getEqualsIndex(token.substring(0, token.length() - 2));
    }

    private Vector getCookieTokens(String cookieHeader) {
        StringReader sr = new StringReader(cookieHeader);
        StreamTokenizer st = new StreamTokenizer(sr);
        Vector<String> tokens = new Vector<String>();
        st.resetSyntax();
        st.wordChars(0, 65535);
        st.quoteChar(34);
        st.quoteChar(39);
        st.whitespaceChars(59, 59);
        st.whitespaceChars(44, 44);
        try {
            while (st.nextToken() != -1) {
                tokens.addElement(st.sval.trim());
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        sr.close();
        return tokens;
    }

    private boolean isCookieAttribute(String string, int version) {
        String stringLowercase = string.toLowerCase();
        if (version == 0) {
            return stringLowercase.equals("path") || stringLowercase.equals("domain") || stringLowercase.equals("expires") || stringLowercase.equals("comment") || stringLowercase.equals("max-age") || stringLowercase.equals("version");
        }
        if (version == 1) {
            return stringLowercase.equals("path") || stringLowercase.equals("domain") || stringLowercase.equals("comment") || stringLowercase.equals("commenturl") || stringLowercase.equals("max-age") || stringLowercase.equals("version") || stringLowercase.equals("$version") || stringLowercase.equals("port");
        }
        return false;
    }

    private boolean isCookieReservedWord(String token, int version) {
        if (version == 0) {
            return token.equalsIgnoreCase("secure");
        }
        if (version == 1) {
            return token.equalsIgnoreCase("discard") || token.equalsIgnoreCase("secure");
        }
        return false;
    }

    private void readContentTypeHeader() {
        String contentHeader;
        String string = contentHeader = this._contentHeader != null ? this._contentHeader : this.getHeaderField("Content-type");
        if (contentHeader == null) {
            this._contentType = HttpUnitOptions.getDefaultContentType();
            this._characterSet = HttpUnitOptions.getDefaultCharacterSet();
            this._contentHeader = this._contentType + ";charset=" + this._characterSet;
        } else {
            String[] parts = HttpUnitUtils.parseContentTypeHeader(contentHeader);
            this._contentType = parts[0];
            if (parts[1] != null) {
                this._characterSet = parts[1];
            }
        }
    }

    private WebFrame[] getFrames() throws SAXException {
        if (this._frames == null) {
            Vector list = new Vector();
            this.addFrameTags(list, "frame");
            this._frames = new WebFrame[list.size()];
            list.copyInto(this._frames);
        }
        return this._frames;
    }

    private void addFrameTags(Vector list, String frameTagName) throws SAXException {
        NodeList nl = NodeUtils.getElementsByTagName(this.getReceivedPage().getOriginalDOM(), frameTagName);
        int i = 0;
        while (i < nl.getLength()) {
            Node child = nl.item(i);
            list.addElement(new WebFrame(this.getReceivedPage().getBaseURL(), child, this._frameName));
            ++i;
        }
    }

    private ReceivedPage getReceivedPage() throws SAXException {
        if (this._page == null) {
            try {
                if (!this.isHTML()) {
                    throw new NotHTMLException(this.getContentType());
                }
                this._page = new ReceivedPage(this._url, this._frameName, this.getText(), this.getCharacterSet());
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        return this._page;
    }

    static String getDefaultEncoding() {
        if (_defaultEncoding == null) {
            int i = 0;
            while (i < DEFAULT_ENCODING_CANDIDATES.length) {
                try {
                    _defaultEncoding = DEFAULT_ENCODING_CANDIDATES[i];
                    "abcd".getBytes(_defaultEncoding);
                    return _defaultEncoding;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ++i;
                }
            }
        }
        _defaultEncoding = System.getProperty("file.encoding");
        return _defaultEncoding;
    }

    static {
        IETF_RFC2109 = 0;
        IETF_RFC2965 = 1;
        HTML_CONTENT = HTML_CONTENT;
        UNINITIALIZED_INT = -2;
        DEFAULT_ENCODING_CANDIDATES = new String[]{"iso-8859-1", "us-ascii", "utf-8", "utf8"};
    }
}

