/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.WebRequest;
import java.net.URL;
import org.w3c.dom.Node;

class WebFrame {
    private Node _element;
    private URL _baseURL;
    private String _name;

    WebFrame(URL baseURL, Node frameNode, String parentFrameName) {
        this._element = frameNode;
        this._baseURL = baseURL;
        this._name = this.getFrameName(parentFrameName);
    }

    String getName() {
        return this._name;
    }

    private String getFrameName(String parentFrameName) {
        String relativeName = NodeUtils.getNodeAttribute(this._element, "name");
        if (relativeName.length() == 0) {
            return this.toString();
        }
        return WebFrame.getNestedFrameName(parentFrameName, relativeName);
    }

    static String getNestedFrameName(String parentFrameName, String relativeName) {
        if (parentFrameName.equalsIgnoreCase("_top")) {
            return relativeName;
        }
        return parentFrameName + ':' + relativeName;
    }

    static String getTargetFrameName(String sourceFrameName, String relativeName) {
        if (sourceFrameName.indexOf(58) < 0) {
            return relativeName;
        }
        return sourceFrameName.substring(0, sourceFrameName.lastIndexOf(58)) + ':' + relativeName;
    }

    WebRequest getInitialRequest() {
        return new GetMethodWebRequest(this._baseURL, NodeUtils.getNodeAttribute(this._element, "src"), this.getName());
    }

    boolean hasInitialRequest() {
        return NodeUtils.getNodeAttribute(this._element, "src").length() > 0;
    }
}

