/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.MessageBody;
import com.meterware.httpunit.SubmitButton;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public abstract class MessageBodyWebRequest
extends WebRequest {
    protected MessageBodyWebRequest(String urlString) {
        super(urlString);
    }

    protected MessageBodyWebRequest(URL urlBase, String urlString, String target) {
        super(urlBase, urlString, target);
    }

    protected MessageBodyWebRequest(WebForm sourceForm, SubmitButton button, int x, int y) {
        super(sourceForm, button, x, y);
    }

    protected abstract MessageBody getMessageBody();

    protected void writeMessageBody(OutputStream stream) throws IOException {
        this.getMessageBody().writeTo(stream);
    }

    protected void completeRequest(URLConnection connection) throws IOException {
        ((HttpURLConnection)connection).setRequestMethod(this.getMethod());
        connection.setDoInput(true);
        connection.setDoOutput(true);
        OutputStream stream = connection.getOutputStream();
        this.writeMessageBody(stream);
        stream.flush();
        stream.close();
    }

    protected String getContentType() {
        return this.getMessageBody().getContentType();
    }

    public static class InputStreamMessageBody
    extends MessageBody {
        private InputStream _source;
        private String _contentType;

        public InputStreamMessageBody(MessageBodyWebRequest request, InputStream source, String contentType) {
            super(request);
            this._source = source;
            this._contentType = contentType;
        }

        String getContentType() {
            return this._contentType;
        }

        void writeTo(OutputStream outputStream) throws IOException {
            byte[] buffer = new byte[8192];
            int count = 0;
            do {
                outputStream.write(buffer, 0, count);
            } while ((count = this._source.read(buffer, 0, buffer.length)) != -1);
            this._source.close();
        }
    }
}

