/*
 * Decompiled with CFR 0.152.
 */
package org.drools.leaps;

import java.io.Serializable;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.common.BetaNodeBinder;
import org.drools.common.InternalFactHandle;
import org.drools.rule.Column;
import org.drools.spi.FieldConstraint;
import org.drools.spi.Tuple;

public class ColumnConstraints
implements Serializable {
    private Class classType;
    private final FieldConstraint[] alphaConstraints;
    private final boolean alphaPresent;
    private final BetaNodeBinder beta;
    private final boolean betaPresent;

    public ColumnConstraints(Column column, List list, BetaNodeBinder betaNodeBinder) {
        this.classType = ((ClassObjectType)column.getObjectType()).getClassType();
        if (betaNodeBinder != null) {
            this.beta = betaNodeBinder;
            this.betaPresent = true;
        } else {
            this.beta = null;
            this.betaPresent = false;
        }
        if (list != null && list.size() > 0) {
            this.alphaConstraints = list.toArray(new FieldConstraint[0]);
            this.alphaPresent = true;
        } else {
            this.alphaConstraints = null;
            this.alphaPresent = false;
        }
    }

    protected final Class getClassType() {
        return this.classType;
    }

    protected final boolean isAllowed(InternalFactHandle internalFactHandle, Tuple tuple, WorkingMemory workingMemory) {
        return this.isAllowedAlpha(internalFactHandle, tuple, workingMemory) && this.isAllowedBeta(internalFactHandle, tuple, workingMemory);
    }

    public final boolean isAllowedAlpha(InternalFactHandle internalFactHandle, Tuple tuple, WorkingMemory workingMemory) {
        if (this.alphaPresent) {
            int n = this.alphaConstraints.length;
            for (int i = 0; i < n; ++i) {
                if (this.alphaConstraints[i].isAllowed(internalFactHandle, tuple, workingMemory)) continue;
                return false;
            }
        }
        return true;
    }

    protected final boolean isAllowedBeta(InternalFactHandle internalFactHandle, Tuple tuple, WorkingMemory workingMemory) {
        if (this.betaPresent) {
            return this.beta.isAllowed(internalFactHandle, tuple, workingMemory);
        }
        return true;
    }

    protected final boolean isAlphaPresent() {
        return this.alphaPresent;
    }
}

