/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.MavenArtifactFilterManager;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.extension.ExtensionManager;
import org.apache.maven.model.Extension;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public class DefaultExtensionManager
extends AbstractLogEnabled
implements ExtensionManager,
Contextualizable {
    private ArtifactResolver artifactResolver;
    private ArtifactMetadataSource artifactMetadataSource;
    private PlexusContainer container;
    private ArtifactFilter artifactFilter = MavenArtifactFilterManager.createStandardFilter();
    private WagonManager wagonManager;
    private static final String CONTAINER_NAME = "extensions";

    public void addExtension(Extension extension, MavenProject project, ArtifactRepository localRepository) throws ArtifactResolutionException, PlexusContainerException, ArtifactNotFoundException {
        String extensionId = ArtifactUtils.versionlessKey((String)extension.getGroupId(), (String)extension.getArtifactId());
        this.getLogger().debug("Initialising extension: " + extensionId);
        Artifact artifact = (Artifact)project.getExtensionArtifactMap().get(extensionId);
        if (artifact != null) {
            ProjectArtifactExceptionFilter filter = new ProjectArtifactExceptionFilter(this.artifactFilter, project.getArtifact());
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(Collections.singleton(artifact), project.getArtifact(), localRepository, project.getRemoteArtifactRepositories(), this.artifactMetadataSource, (ArtifactFilter)filter);
            PlexusContainer extensionContainer = this.getExtensionContainer();
            if (extensionContainer == null) {
                extensionContainer = this.container.createChildContainer(CONTAINER_NAME, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            }
            if (result.getArtifacts().size() == 1) {
                Artifact a = (Artifact)result.getArtifacts().iterator().next();
                a = project.replaceWithActiveArtifact(a);
                this.getLogger().debug("Adding extension to core container: " + a.getFile());
                this.container.addJarResource(a.getFile());
            } else {
                Iterator i = result.getArtifacts().iterator();
                while (i.hasNext()) {
                    Artifact a = (Artifact)i.next();
                    a = project.replaceWithActiveArtifact(a);
                    this.getLogger().debug("Adding to extension classpath: " + a.getFile());
                    extensionContainer.addJarResource(a.getFile());
                }
            }
        }
    }

    public void registerWagons() {
        PlexusContainer extensionContainer = this.getExtensionContainer();
        if (extensionContainer != null) {
            try {
                Map wagons = extensionContainer.lookupMap(Wagon.ROLE);
                this.wagonManager.registerWagons(wagons.keySet(), extensionContainer);
            }
            catch (ComponentLookupException componentLookupException) {
                // empty catch block
            }
        }
    }

    private PlexusContainer getExtensionContainer() {
        return this.container.getChildContainer(CONTAINER_NAME);
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private static final class ProjectArtifactExceptionFilter
    implements ArtifactFilter {
        private ArtifactFilter passThroughFilter;
        private String projectDependencyConflictId;

        ProjectArtifactExceptionFilter(ArtifactFilter passThroughFilter, Artifact projectArtifact) {
            this.passThroughFilter = passThroughFilter;
            this.projectDependencyConflictId = projectArtifact.getDependencyConflictId();
        }

        public boolean include(Artifact artifact) {
            String depConflictId = artifact.getDependencyConflictId();
            return this.projectDependencyConflictId.equals(depConflictId) || this.passThroughFilter.include(artifact);
        }
    }
}

