/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.wsdl.WSDLBindingFault;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLInterface;

public class WSDLBinding
implements Serializable {
    private static final long serialVersionUID = -7699953670233209811L;
    private static final Logger log = Logger.getLogger(WSDLBinding.class);
    private final WSDLDefinitions wsdlDefinitions;
    private final QName name;
    private QName interfaceName;
    private String type;
    private ArrayList<WSDLBindingFault> faults = new ArrayList();
    private ArrayList<WSDLBindingOperation> operations = new ArrayList();

    public WSDLBinding(WSDLDefinitions wsdlDefinitions, QName name) {
        this.wsdlDefinitions = wsdlDefinitions;
        this.name = name;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public QName getName() {
        return this.name;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        log.trace((Object)("setInterfaceName: " + this.name));
        this.interfaceName = interfaceName;
    }

    public WSDLInterface getInterface() {
        WSDLInterface wsdlInterface = this.wsdlDefinitions.getInterface(this.interfaceName);
        if (wsdlInterface == null) {
            throw new WSException("Cannot get interface for name: " + this.interfaceName);
        }
        return wsdlInterface;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public WSDLBindingFault[] getFaults() {
        WSDLBindingFault[] arr = new WSDLBindingFault[this.faults.size()];
        this.faults.toArray(arr);
        return arr;
    }

    public void addFault(WSDLBindingFault fault) {
        this.faults.add(fault);
    }

    public WSDLBindingOperation[] getOperations() {
        WSDLBindingOperation[] arr = new WSDLBindingOperation[this.operations.size()];
        this.operations.toArray(arr);
        return arr;
    }

    public WSDLBindingOperation getOperationByRef(QName qname) {
        WSDLBindingOperation wsdlBindingOperation = null;
        for (WSDLBindingOperation aux : this.operations) {
            if (!aux.getRef().equals(qname)) continue;
            if (wsdlBindingOperation != null) {
                log.warn((Object)("Multiple binding operations reference: " + qname));
            }
            wsdlBindingOperation = aux;
        }
        if (wsdlBindingOperation == null) {
            log.warn((Object)("Cannot obtain binding operation for ref: " + qname));
        }
        return wsdlBindingOperation;
    }

    public void addOperation(WSDLBindingOperation operation) {
        this.operations.add(operation);
    }
}

