/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.logging.Logger;
import org.jboss.ws.core.server.ServiceEndpointManager;
import org.jboss.ws.integration.UnifiedVirtualFile;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnifiedMetaData {
    private static Logger log = Logger.getLogger(UnifiedMetaData.class);
    private String deploymentName;
    private ClassLoader classLoader;
    private UnifiedVirtualFile vfsRoot;
    private String securityDomain;
    private static String implementationVersion;
    private static boolean isFinalRelease;
    Map<String, WSDLDefinitions> wsdlMap = new HashMap<String, WSDLDefinitions>();
    Map<String, JavaWsdlMapping> jaxrpcMap = new HashMap<String, JavaWsdlMapping>();
    private List<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
    private boolean eagerInitialized;
    private boolean validated;

    public UnifiedMetaData(UnifiedVirtualFile vfsRoot) {
        if (vfsRoot == null) {
            throw new IllegalArgumentException("VFS root cannot be null");
        }
        this.vfsRoot = vfsRoot;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            throw new IllegalStateException("Class loader not available");
        }
        return this.classLoader;
    }

    public UnifiedVirtualFile getRootFile() {
        return this.vfsRoot;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public void setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String domain) {
        String prefix = "java:/jaas/";
        if (domain != null && domain.startsWith(prefix)) {
            domain = domain.substring(prefix.length());
        }
        this.securityDomain = domain;
    }

    public List<ServiceMetaData> getServices() {
        return new ArrayList<ServiceMetaData>(this.services);
    }

    public void addService(ServiceMetaData serviceMetaData) {
        this.services.add(serviceMetaData);
    }

    public void addWsdlDefinition(String wsdlFile, WSDLDefinitions wsdlDefinitions) {
        this.wsdlMap.put(wsdlFile, wsdlDefinitions);
    }

    public WSDLDefinitions getWsdlDefinition(String wsdlFile) {
        return this.wsdlMap.get(wsdlFile);
    }

    public void addMappingDefinition(String jaxrpcFile, JavaWsdlMapping javaWsdlMapping) {
        this.jaxrpcMap.put(jaxrpcFile, javaWsdlMapping);
    }

    public JavaWsdlMapping getMappingDefinition(String jaxrpcFile) {
        return this.jaxrpcMap.get(jaxrpcFile);
    }

    public void validate() {
        if (!this.validated) {
            for (ServiceMetaData service : this.services) {
                service.validate();
            }
            this.validated = true;
        }
    }

    public boolean isEagerInitialized() {
        return this.eagerInitialized;
    }

    public void eagerInitialize() {
        if (!this.eagerInitialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Eagerly initialize the meta data model");
            }
            for (ServiceMetaData service : this.services) {
                service.eagerInitialize();
            }
            this.eagerInitialized = true;
        }
    }

    public static String getImplementationVersion() {
        if (implementationVersion == null && (implementationVersion = ServiceEndpointManager.class.getPackage().getImplementationVersion()) != null) {
            isFinalRelease = new StringTokenizer(implementationVersion).nextToken().endsWith(".GA");
        }
        return implementationVersion;
    }

    public static boolean isFinalRelease() {
        UnifiedMetaData.getImplementationVersion();
        return isFinalRelease;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nUnifiedMetaData: ");
        buffer.append("\n implementation: " + UnifiedMetaData.getImplementationVersion());
        buffer.append("\n deploymentName: " + this.getDeploymentName());
        buffer.append("\n securityDomain: " + this.getSecurityDomain());
        buffer.append("\n");
        for (ServiceMetaData serviceMetaData : this.services) {
            buffer.append(serviceMetaData);
        }
        return buffer.toString();
    }
}

