/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.policy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.ws.WSException;
import org.jboss.ws.core.utils.DOMUtils;
import org.jboss.ws.core.utils.DOMWriter;
import org.jboss.ws.extensions.policy.PolicyAlternative;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy {
    public static final String URI_POLICY = "http://schemas.xmlsoap.org/ws/2004/09/policy";
    public static final String URI_SECURITY_UTILITY = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    private String targetNamespace;
    private String baseURI;
    private String id;
    private Collection<PolicyAlternative> alternatives = new ArrayList<PolicyAlternative>();
    private NamespaceRegistry nsRegistry = new NamespaceRegistry();

    Policy() {
    }

    public NamespaceRegistry getNamespaceRegistry() {
        return this.nsRegistry;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void addPolicyAlternative(PolicyAlternative polAlternative) {
        this.alternatives.add(polAlternative);
    }

    public Collection<PolicyAlternative> getPolicyAlternatives() {
        return new ArrayList<PolicyAlternative>(this.alternatives);
    }

    public Element toElement() {
        String xmlString = this.toXMLString(false);
        try {
            return DOMUtils.parse(xmlString);
        }
        catch (IOException ex) {
            throw new WSException("Cannot parse: " + xmlString, ex);
        }
    }

    public String toXMLString(boolean pretty) {
        if (pretty) {
            Element elPolicy = this.toElement();
            return DOMWriter.printNode(elPolicy, true);
        }
        StringBuilder xmlBuffer = new StringBuilder("<wsp:Policy");
        Iterator it = this.nsRegistry.getRegisteredURIs();
        while (it.hasNext()) {
            String nsURI = (String)it.next();
            String prefix = this.nsRegistry.getPrefix(nsURI);
            xmlBuffer.append(" xmlns:" + prefix + "='" + nsURI + "'");
        }
        if (this.id != null) {
            xmlBuffer.append(" xmlns:wsu='http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd'");
            xmlBuffer.append(" wsu:Id='" + this.id + "'");
        }
        if (this.baseURI != null) {
            xmlBuffer.append(" xml:base='" + this.baseURI + "'");
        }
        if (this.targetNamespace != null) {
            xmlBuffer.append(" TargetNamespace='" + this.targetNamespace + "'");
        }
        xmlBuffer.append(">");
        xmlBuffer.append("<wsp:ExactlyOne>");
        for (PolicyAlternative polAlternative : this.alternatives) {
            xmlBuffer.append(polAlternative.toXMLString(false));
        }
        xmlBuffer.append("</wsp:ExactlyOne>");
        xmlBuffer.append("</wsp:Policy>");
        String xmlString = xmlBuffer.toString();
        return xmlString;
    }

    public String toString() {
        return this.toXMLString(true);
    }
}

