/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.ws.WSException;
import org.jboss.ws.core.soap.MessageFactoryImpl;

public class SOAPMessageUnMarshaller
implements UnMarshaller {
    private static Logger log = Logger.getLogger(SOAPMessageUnMarshaller.class);
    private static List validResponseCodes = new ArrayList();

    public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Read input stream with metadata=" + metadata));
        }
        try {
            Integer resCode = (Integer)metadata.get("ResponseCode");
            String resMessage = (String)metadata.get("ResponseCodeMessage");
            if (resCode != null && !validResponseCodes.contains(resCode)) {
                throw new WSException("Invalid HTTP server response [" + resCode + "] - " + resMessage);
            }
            MimeHeaders mimeHeaders = this.getMimeHeaders(metadata);
            SOAPMessage soapMsg = new MessageFactoryImpl().createMessage(mimeHeaders, inputStream, true);
            return soapMsg;
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot unmarshall SOAPMessage", (Throwable)e);
            IOException e2 = new IOException(e.toString());
            e2.initCause(e);
            throw e2;
        }
    }

    public void setClassLoader(ClassLoader classloader) {
    }

    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        return new SOAPMessageUnMarshaller();
    }

    private MimeHeaders getMimeHeaders(Map metadata) {
        log.debug((Object)("getMimeHeaders from: " + metadata));
        MimeHeaders headers = new MimeHeaders();
        for (String key : metadata.keySet()) {
            Object value = metadata.get(key);
            if (key == null || !(value instanceof List)) continue;
            for (Object listValue : (List)value) {
                headers.addHeader(key, listValue.toString());
            }
        }
        return headers;
    }

    static {
        validResponseCodes.add(200);
        validResponseCodes.add(202);
        validResponseCodes.add(500);
    }
}

