/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.Constants;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPBodyImpl;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPHeaderImpl;
import org.jboss.ws.core.soap.SOAPPartImpl;
import org.w3c.dom.Document;

public class SOAPEnvelopeImpl
extends SOAPElementImpl
implements SOAPEnvelope {
    private SOAPPartImpl soapPart;

    public SOAPEnvelopeImpl(SOAPPartImpl soapPart, SOAPElement element) throws SOAPException {
        super((SOAPElementImpl)element);
        this.soapPart = soapPart;
        soapPart.setEnvelope(this);
        String prefix = this.getPrefix();
        String namespaceURI = this.getNamespaceURI();
        String localName = this.getLocalName();
        if (!"Envelope".equals(localName)) {
            throw new IllegalArgumentException("Cannot create SOAP envelope from: " + element.getElementQName());
        }
        this.assertEnvelopeNamespace(namespaceURI);
        this.addNamespaceDeclaration(prefix, namespaceURI);
        if (null == soapPart.getEnvelope().getHeader()) {
            this.addHeader();
        }
        if (null == soapPart.getEnvelope().getBody()) {
            this.addBody();
        }
    }

    SOAPEnvelopeImpl(SOAPPartImpl soapPart, String namespace) throws SOAPException {
        super("Envelope", "env", namespace);
        this.soapPart = soapPart;
        soapPart.setEnvelope(this);
        this.assertEnvelopeNamespace(namespace);
        this.addNamespaceDeclaration(this.getPrefix(), namespace);
        this.addHeader();
        this.addBody();
    }

    public SOAPMessage getSOAPMessage() {
        return this.soapPart.getSOAPMessage();
    }

    public SOAPBody addBody() throws SOAPException {
        SOAPBody body = this.getBody();
        if (body != null) {
            throw new SOAPException("SOAPEnvelope already has a body element");
        }
        body = new SOAPBodyImpl(this.getPrefix(), this.getNamespaceURI());
        this.addChildElement((SOAPElement)body);
        return body;
    }

    public SOAPHeader addHeader() throws SOAPException {
        SOAPHeader header = this.getHeader();
        if (header != null) {
            throw new SOAPException("SOAPEnvelope already has a header element");
        }
        header = new SOAPHeaderImpl(this.getPrefix(), this.getNamespaceURI());
        return (SOAPHeader)this.addChildElement((SOAPElement)header);
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        String envNamespace = this.getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(envNamespace) && name.equals(new NameImpl("encodingStyle", "env", envNamespace))) {
            throw new SOAPException("Cannot set encodingStyle on: " + this.getElementQName());
        }
        return super.addAttribute(name, value);
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        String envNamespace = this.getNamespaceURI();
        if ("http://www.w3.org/2003/05/soap-envelope".equals(envNamespace) && !(child instanceof SOAPHeader) && !(child instanceof SOAPBody)) {
            throw new SOAPException("SOAPHeader or SOAPBody expected");
        }
        return super.addChildElement(child);
    }

    public Name createName(String localName) throws SOAPException {
        return new NameImpl(localName);
    }

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        return new NameImpl(localName, prefix, uri);
    }

    public SOAPBody getBody() throws SOAPException {
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!node.getLocalName().equals("Body")) continue;
            return (SOAPBody)node;
        }
        return null;
    }

    public SOAPHeader getHeader() throws SOAPException {
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (!node.getLocalName().equals("Header")) continue;
            return (SOAPHeader)node;
        }
        return null;
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        if (value.trim().length() > 0) {
            throw new SOAPException("Cannot add Text node to SOAPEnvelope");
        }
        return super.addTextNode(value);
    }

    public Document getOwnerDocument() {
        return this.soapPart;
    }

    private void assertEnvelopeNamespace(String namespaceURI) {
        if (!"http://www.w3.org/2003/05/soap-envelope".equals(namespaceURI) && !"http://schemas.xmlsoap.org/soap/envelope/".equals(namespaceURI)) {
            QName faultCode = Constants.SOAP11_FAULT_CODE_VERSION_MISMATCH;
            String faultString = "Invalid SOAP envelope namespace: " + namespaceURI;
            throw new SOAPFaultException(faultCode, faultString, null, null);
        }
    }
}

