/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxws;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.soap.MessageContextAssociation;
import org.jboss.ws.core.utils.HashCodeUtil;
import org.jboss.ws.metadata.umdm.EndpointMetaData;

public class JAXBContextCache {
    private Map<Integer, JAXBContext> cache = new ConcurrentHashMap<Integer, JAXBContext>();

    private JAXBContext get(Integer id) {
        return this.cache.get(id);
    }

    private void add(Integer id, JAXBContext context) {
        this.cache.put(id, context);
    }

    public JAXBContext getInstance(Class[] classes) throws JAXBException {
        Integer id = JAXBContextCache.buildId(classes);
        JAXBContext ctx = this.get(id);
        if (null == ctx) {
            ctx = JAXBContext.newInstance((Class[])classes);
            this.add(id, ctx);
        }
        return ctx;
    }

    public JAXBContext getInstance(Class clazz) throws JAXBException {
        Integer id = JAXBContextCache.buildId(clazz);
        JAXBContext ctx = this.get(id);
        if (null == ctx) {
            ctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
            this.add(id, ctx);
        }
        return ctx;
    }

    public static JAXBContextCache getContextCache() {
        CommonMessageContext msgContext = MessageContextAssociation.peekMessageContext();
        EndpointMetaData epMetaData = msgContext.getEndpointMetaData();
        return epMetaData.getJaxbCache();
    }

    private static Integer buildId(Class[] classes) {
        int sum = 23;
        for (Class cls : classes) {
            sum = HashCodeUtil.hash(sum, cls.getName());
        }
        return new Integer(sum);
    }

    private static Integer buildId(Class clazz) {
        return JAXBContextCache.buildId(new Class[]{clazz});
    }
}

