/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import java.util.HashSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.BufferedStreamResult;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.binding.SerializerSupport;
import org.jboss.xb.binding.NamespaceRegistry;
import org.jboss.xb.binding.SimpleTypeBindings;
import org.w3c.dom.NamedNodeMap;

public class QNameSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(QNameSerializer.class);

    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        log.debug((Object)("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]"));
        QName qnameValue = (QName)value;
        String nsURI = qnameValue.getNamespaceURI();
        NamespaceRegistry nsRegistry = serContext.getNamespaceRegistry();
        HashSet<String> nsExtras = new HashSet<String>();
        if (nsURI.length() > 0) {
            qnameValue = new QName(nsURI, qnameValue.getLocalPart());
            qnameValue = nsRegistry.registerQName(qnameValue);
            if (!nsURI.equals(xmlName.getNamespaceURI())) {
                nsExtras.add(nsURI);
            }
        }
        String valueStr = SimpleTypeBindings.marshalQName((QName)qnameValue, (NamespaceContext)nsRegistry);
        String xmlFragment = this.wrapValueStr(xmlName, valueStr, nsRegistry, nsExtras, attributes, true);
        return new BufferedStreamResult(xmlFragment);
    }
}

