/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.pretty.DDLFormatter;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaUpdate {
    private static final Log log = LogFactory.getLog(SchemaUpdate.class);
    private ConnectionHelper connectionHelper;
    private Configuration configuration;
    private Dialect dialect;
    private List exceptions;
    private boolean haltOnError = false;
    private boolean format = true;
    private String outputFile = null;
    private String delimiter;

    public SchemaUpdate(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaUpdate(Configuration cfg, Properties connectionProperties) throws HibernateException {
        this.configuration = cfg;
        this.dialect = Dialect.getDialect(connectionProperties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)connectionProperties);
        this.connectionHelper = new ManagedProviderConnectionHelper(props);
        this.exceptions = new ArrayList();
    }

    public SchemaUpdate(Configuration cfg, Settings settings) throws HibernateException {
        this.configuration = cfg;
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.exceptions = new ArrayList();
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean doUpdate = true;
            String propFile = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (args[i].startsWith("--text")) {
                        doUpdate = false;
                        continue;
                    }
                    if (!args[i].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i].substring(9)).newInstance());
                    continue;
                }
                cfg.addFile(args[i]);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            new SchemaUpdate(cfg).execute(script, doUpdate);
        }
        catch (Exception e) {
            log.error((Object)"Error running schema update", (Throwable)e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(boolean script, boolean doUpdate) {
        log.info((Object)"Running hbm2ddl schema update");
        Connection connection = null;
        Statement stmt = null;
        Writer outputFileWriter = null;
        this.exceptions.clear();
        try {
            DatabaseMetadata meta;
            try {
                log.info((Object)"fetching database metadata");
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                meta = new DatabaseMetadata(connection, this.dialect);
                stmt = connection.createStatement();
            }
            catch (SQLException sqle) {
                this.exceptions.add(sqle);
                log.error((Object)"could not get database metadata", (Throwable)sqle);
                throw sqle;
            }
            log.info((Object)"updating schema");
            if (this.outputFile != null) {
                log.info((Object)("writing generated schema to file: " + this.outputFile));
                outputFileWriter = new FileWriter(this.outputFile);
            }
            String[] createSQL = this.configuration.generateSchemaUpdateScript(this.dialect, meta);
            for (int j = 0; j < createSQL.length; ++j) {
                String sql = createSQL[j];
                String formatted = this.format(sql);
                try {
                    if (this.delimiter != null) {
                        formatted = formatted + this.delimiter;
                    }
                    if (script) {
                        System.out.println(formatted);
                    }
                    if (this.outputFile != null) {
                        outputFileWriter.write(formatted + "\n");
                    }
                    if (!doUpdate) continue;
                    log.debug((Object)sql);
                    stmt.executeUpdate(formatted);
                    continue;
                }
                catch (SQLException e) {
                    if (this.haltOnError) {
                        throw new JDBCException("Error during DDL export", e);
                    }
                    this.exceptions.add(e);
                    log.error((Object)("Unsuccessful: " + sql));
                    log.error((Object)e.getMessage());
                }
            }
            log.info((Object)"schema update complete");
        }
        catch (Exception e) {
            this.exceptions.add(e);
            log.error((Object)"could not complete schema update", (Throwable)e);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                this.connectionHelper.release();
            }
            catch (Exception e) {
                this.exceptions.add(e);
                log.error((Object)"Error closing connection", (Throwable)e);
            }
            try {
                if (outputFileWriter != null) {
                    outputFileWriter.close();
                }
            }
            catch (Exception e) {
                this.exceptions.add(e);
                log.error((Object)"Error closing connection", (Throwable)e);
            }
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public void setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    private String format(String sql) {
        return this.format ? new DDLFormatter(sql).format() : sql;
    }
}

