/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.ProxyVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.Type;

public abstract class ReattachVisitor
extends ProxyVisitor {
    private static final Log log = LogFactory.getLog(ReattachVisitor.class);
    private final Serializable ownerIdentifier;
    private final Object owner;

    public ReattachVisitor(EventSource session, Serializable ownerIdentifier, Object owner) {
        super(session);
        this.ownerIdentifier = ownerIdentifier;
        this.owner = owner;
    }

    final Serializable getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    final Object getOwner() {
        return this.owner;
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        Type[] types = componentType.getSubtypes();
        if (component == null) {
            this.processValues(new Object[types.length], types);
        } else {
            super.processComponent(component, componentType);
        }
        return null;
    }

    void removeCollection(CollectionPersister role, Serializable collectionKey, EventSource source) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("collection dereferenced while transient " + MessageHelper.collectionInfoString(role, this.ownerIdentifier, source.getFactory())));
        }
        source.getActionQueue().addAction(new CollectionRemoveAction(this.owner, role, collectionKey, false, (SessionImplementor)source));
    }

    final Serializable extractCollectionKeyFromOwner(CollectionPersister role) {
        if (role.getCollectionType().useLHSPrimaryKey()) {
            return this.ownerIdentifier;
        }
        return (Serializable)role.getOwnerEntityPersister().getPropertyValue(this.owner, role.getCollectionType().getLHSPropertyName(), this.getSession().getEntityMode());
    }
}

