/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.AnsiTrimEmulationFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;

public class DB2Dialect
extends Dialect {
    public DB2Dialect() {
        this.registerColumnType(-7, "smallint");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "timestamp");
        this.registerColumnType(-3, "varchar($l) for bit data");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(2004, "blob($l)");
        this.registerColumnType(2005, "clob($l)");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("absval", new StandardSQLFunction("absval"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("ceiling", new StandardSQLFunction("ceiling"));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cot", Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction("degrees", Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("float", new StandardSQLFunction("float", Hibernate.DOUBLE));
        this.registerFunction("hex", new StandardSQLFunction("hex", Hibernate.STRING));
        this.registerFunction("ln", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction("log10", Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction("radians", Hibernate.DOUBLE));
        this.registerFunction("rand", new NoArgSQLFunction("rand", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("soundex", new StandardSQLFunction("soundex", Hibernate.STRING));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction("stddev", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction("variance", Hibernate.DOUBLE));
        this.registerFunction("julian_day", new StandardSQLFunction("julian_day", Hibernate.INTEGER));
        this.registerFunction("microsecond", new StandardSQLFunction("microsecond", Hibernate.INTEGER));
        this.registerFunction("midnight_seconds", new StandardSQLFunction("midnight_seconds", Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction("minute", Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction("month", Hibernate.INTEGER));
        this.registerFunction("monthname", new StandardSQLFunction("monthname", Hibernate.STRING));
        this.registerFunction("quarter", new StandardSQLFunction("quarter", Hibernate.INTEGER));
        this.registerFunction("hour", new StandardSQLFunction("hour", Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction("second", Hibernate.INTEGER));
        this.registerFunction("current_date", new NoArgSQLFunction("current date", Hibernate.DATE, false));
        this.registerFunction("date", new StandardSQLFunction("date", Hibernate.DATE));
        this.registerFunction("day", new StandardSQLFunction("day", Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction("dayname", Hibernate.STRING));
        this.registerFunction("dayofweek", new StandardSQLFunction("dayofweek", Hibernate.INTEGER));
        this.registerFunction("dayofweek_iso", new StandardSQLFunction("dayofweek_iso", Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", Hibernate.INTEGER));
        this.registerFunction("days", new StandardSQLFunction("days", Hibernate.LONG));
        this.registerFunction("current_time", new NoArgSQLFunction("current time", Hibernate.TIME, false));
        this.registerFunction("time", new StandardSQLFunction("time", Hibernate.TIME));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current timestamp", Hibernate.TIMESTAMP, false));
        this.registerFunction("timestamp", new StandardSQLFunction("timestamp", Hibernate.TIMESTAMP));
        this.registerFunction("timestamp_iso", new StandardSQLFunction("timestamp_iso", Hibernate.TIMESTAMP));
        this.registerFunction("week", new StandardSQLFunction("week", Hibernate.INTEGER));
        this.registerFunction("week_iso", new StandardSQLFunction("week_iso", Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction("year", Hibernate.INTEGER));
        this.registerFunction("double", new StandardSQLFunction("double", Hibernate.DOUBLE));
        this.registerFunction("varchar", new StandardSQLFunction("varchar", Hibernate.STRING));
        this.registerFunction("real", new StandardSQLFunction("real", Hibernate.FLOAT));
        this.registerFunction("bigint", new StandardSQLFunction("bigint", Hibernate.LONG));
        this.registerFunction("char", new StandardSQLFunction("char", Hibernate.CHARACTER));
        this.registerFunction("integer", new StandardSQLFunction("integer", Hibernate.INTEGER));
        this.registerFunction("smallint", new StandardSQLFunction("smallint", Hibernate.SHORT));
        this.registerFunction("digits", new StandardSQLFunction("digits", Hibernate.STRING));
        this.registerFunction("chr", new StandardSQLFunction("chr", Hibernate.CHARACTER));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("ucase", new StandardSQLFunction("ucase"));
        this.registerFunction("lcase", new StandardSQLFunction("lcase"));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.LONG));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("substr", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("posstr", new StandardSQLFunction("posstr", Hibernate.INTEGER));
        this.registerFunction("substring", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("bit_length", new SQLFunctionTemplate(Hibernate.INTEGER, "length(?1)*8"));
        this.registerFunction("trim", new AnsiTrimEmulationFunction());
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "", "||", ""));
        this.registerFunction("str", new SQLFunctionTemplate(Hibernate.STRING, "rtrim(char(?1))"));
        this.registerKeyword("current");
        this.registerKeyword("date");
        this.registerKeyword("time");
        this.registerKeyword("timestamp");
        this.registerKeyword("fetch");
        this.registerKeyword("first");
        this.registerKeyword("rows");
        this.registerKeyword("only");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public String getLowercaseFunction() {
        return "lcase";
    }

    public String getAddColumnString() {
        return "add column";
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "values identity_val_local()";
    }

    public String getIdentityColumnString() {
        return "generated by default as identity";
    }

    public String getIdentityInsertString() {
        return "default";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "values nextval for " + sequenceName;
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getQuerySequencesString() {
        return "select seqname from sysibm.syssequences";
    }

    public boolean supportsLimit() {
        return true;
    }

    private String getRowNumber(String sql) {
        StringBuffer rownumber = new StringBuffer(50).append("rownumber() over(");
        int orderByIndex = sql.toLowerCase().indexOf("order by");
        if (orderByIndex > 0 && !DB2Dialect.hasDistinct(sql)) {
            rownumber.append(sql.substring(orderByIndex));
        }
        rownumber.append(") as rownumber_,");
        return rownumber.toString();
    }

    public String getLimitString(String sql, boolean hasOffset) {
        int startOfSelect = sql.toLowerCase().indexOf("select");
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100).append(sql.substring(0, startOfSelect)).append("select * from ( select ").append(this.getRowNumber(sql));
        if (DB2Dialect.hasDistinct(sql)) {
            pagingSelect.append(" row_.* from ( ").append(sql.substring(startOfSelect)).append(" ) as row_");
        } else {
            pagingSelect.append(sql.substring(startOfSelect + 6));
        }
        pagingSelect.append(" ) as temp_ where rownumber_ ");
        if (hasOffset) {
            pagingSelect.append("between ?+1 and ?");
        } else {
            pagingSelect.append("<= ?");
        }
        return pagingSelect.toString();
    }

    private static boolean hasDistinct(String sql) {
        return sql.toLowerCase().indexOf("select distinct") >= 0;
    }

    public String getForUpdateString() {
        return " for read only with rs";
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsNotNullUnique() {
        return false;
    }

    public String getSelectClauseNullString(int sqlType) {
        String literal;
        switch (sqlType) {
            case 1: 
            case 12: {
                literal = "'x'";
                break;
            }
            case 91: {
                literal = "'2000-1-1'";
                break;
            }
            case 93: {
                literal = "'2000-1-1 00:00:00'";
                break;
            }
            case 92: {
                literal = "'00:00:00'";
                break;
            }
            default: {
                literal = "0";
            }
        }
        return "nullif(" + literal + ',' + literal + ')';
    }

    public static void main(String[] args) {
        System.out.println(new DB2Dialect().getLimitString("/*foo*/ select * from foos", true));
        System.out.println(new DB2Dialect().getLimitString("/*foo*/ select distinct * from foos", true));
        System.out.println(new DB2Dialect().getLimitString("/*foo*/ select * from foos foo order by foo.bar, foo.baz", true));
        System.out.println(new DB2Dialect().getLimitString("/*foo*/ select distinct * from foos foo order by foo.bar, foo.baz", true));
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public int registerResultSetOutParameter(CallableStatement statement, int col) throws SQLException {
        return col;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        ResultSet rs = ps.getResultSet();
        return rs;
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String getCreateTemporaryTableString() {
        return "declare global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "not logged";
    }

    public String generateTemporaryTableName(String baseTableName) {
        return "session." + super.generateTemporaryTableName(baseTableName);
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "values current timestamp";
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public boolean supportsParametersInInsertSelect() {
        return false;
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "sysdate";
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsLobValueChangePropogation() {
        return false;
    }
}

