/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jmx;

import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.NonSerializableFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.jmx.JbpmServiceMBean;

public class JbpmService
extends ServiceMBeanSupport
implements JbpmServiceMBean {
    String jndiName = null;
    String jbpmCfgResource = null;
    String jbpmContextName = null;

    protected void startService() throws Exception {
        this.log.debug((Object)"starting jbpm service...");
        JbpmConfiguration jbpmConfiguration = JbpmConfiguration.getInstance((String)this.jbpmCfgResource);
        this.bind(jbpmConfiguration, this.jndiName);
    }

    protected void stopService() throws Exception {
        this.log.debug((Object)"stopping jbpm service...");
        this.unbind(this.jndiName);
    }

    private void bind(Object object, String jndiName) throws NamingException {
        InitialContext rootCtx = new InitialContext();
        Name fullName = rootCtx.getNameParser("").parse(jndiName);
        this.log.debug((Object)("binding '" + object + "' to '" + jndiName + "'"));
        NonSerializableFactory.rebind((Name)fullName, (Object)object, (boolean)true);
    }

    private void unbind(String jndiName) throws NamingException {
        InitialContext rootCtx = new InitialContext();
        this.log.debug((Object)("unbinding '" + jndiName + "'"));
        rootCtx.unbind(jndiName);
        NonSerializableFactory.unbind((String)jndiName);
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getJbpmCfgResource() {
        return this.jbpmCfgResource;
    }

    public void setJbpmCfgResource(String jbpmCfgResource) {
        this.jbpmCfgResource = jbpmCfgResource;
    }

    public String getJbpmContextName() {
        return this.jbpmContextName;
    }

    public void setJbpmContextName(String jbpmContextName) {
        this.jbpmContextName = jbpmContextName;
    }
}

