/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.dbga.dbgaProperties;
import com.pointbase.jdbc.jdbc20IResultSet;
import com.pointbase.jdbc.jdbcObject;
import com.pointbase.jdbc.jdbcTmpResultSetMetaData;
import com.pointbase.util.utilReflection;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;

public class jdbcTmpResultSet
extends jdbcObject
implements jdbc20IResultSet,
ResultSet,
Serializable {
    private Vector m_Rows = new Vector();
    private int m_RowNum = -1;
    private ResultSetMetaData m_rsmd;
    protected int m_MaxRows = 0;
    private boolean m_WasPopulateCompleted = false;
    private int m_NumberOfRowsPopulated = 0;
    private boolean m_WasNull = false;

    public jdbcTmpResultSet() throws SQLException {
        this.m_rsmd = new jdbcTmpResultSetMetaData();
        this.m_Rows = new Vector();
        this.m_RowNum = -1;
        this.m_MaxRows = Integer.MAX_VALUE;
    }

    public jdbcTmpResultSet(ResultSet resultSet, int n) throws SQLException {
        this();
        this.m_MaxRows = n;
        this.populate(resultSet);
    }

    public jdbcTmpResultSet(ResultSet resultSet) throws SQLException {
        this(resultSet, Integer.MAX_VALUE);
    }

    public jdbcTmpResultSet(Vector vector, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.m_Rows = vector;
        this.m_MaxRows = vector.size();
        this.m_RowNum = -1;
        this.m_rsmd = resultSetMetaData;
    }

    public int getMaxRows() throws SQLException {
        return this.m_MaxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.m_MaxRows = n;
    }

    public void setMetaData(ResultSetMetaData resultSetMetaData) {
        this.m_rsmd = resultSetMetaData;
    }

    static Object getTmpColumn(ResultSet resultSet, int n) throws SQLException {
        Object object;
        block28: {
            int n2 = resultSet.getMetaData().getColumnType(n);
            if (n2 == -4 || n2 == -3 || n2 == -2) {
                object = resultSet.getBytes(n);
            } else if (n2 == 91) {
                Date date = resultSet.getDate(n);
                object = date != null ? date.toString() : null;
            } else if (n2 == 92) {
                Time time = resultSet.getTime(n);
                object = time != null ? time.toString() : null;
            } else if (n2 == 6 || n2 == 8) {
                double d = resultSet.getDouble(n);
                object = resultSet.wasNull() ? null : Double.toString(d);
            } else if (n2 == 7) {
                float f = resultSet.getFloat(n);
                object = resultSet.wasNull() ? null : Float.toString(f);
            } else if (n2 == 3 || n2 == 2) {
                BigDecimal bigDecimal = resultSet.getBigDecimal(n, resultSet.getMetaData().getScale(n));
                object = bigDecimal != null ? bigDecimal.toString() : null;
            } else if (n2 == 93) {
                Timestamp timestamp = resultSet.getTimestamp(n);
                object = timestamp != null ? timestamp.toString() : null;
            } else if (n2 == 2004) {
                try {
                    Method method = utilReflection.findMethod(resultSet, "getBlob", 1, new Class[]{Integer.TYPE});
                    Blob blob = (Blob)method.invoke((Object)resultSet, new Integer(n));
                    if (blob != null) {
                        object = blob.getBytes(1L, (int)blob.length());
                        break block28;
                    }
                    object = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object = resultSet.getBytes(n);
                }
                catch (IllegalAccessException illegalAccessException) {
                    object = resultSet.getBytes(n);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = resultSet.getBytes(n);
                }
            } else if (n2 == 2005) {
                try {
                    Method method = utilReflection.findMethod(resultSet, "getClob", 1, new Class[]{Integer.TYPE});
                    Clob clob = (Clob)method.invoke((Object)resultSet, new Integer(n));
                    if (clob != null) {
                        object = clob.getSubString(1L, (int)clob.length());
                        break block28;
                    }
                    object = null;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    object = resultSet.getString(n);
                }
                catch (IllegalAccessException illegalAccessException) {
                    object = resultSet.getString(n);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object = resultSet.getString(n);
                }
            } else {
                object = resultSet.getString(n);
            }
        }
        return object;
    }

    public void populate(ResultSet resultSet) throws SQLException {
        this.m_Rows = new Vector();
        this.m_RowNum = -1;
        this.m_WasPopulateCompleted = false;
        this.m_NumberOfRowsPopulated = 0;
        this.m_rsmd = new jdbcTmpResultSetMetaData(resultSet.getMetaData());
        int n = this.m_rsmd.getColumnCount();
        this.m_NumberOfRowsPopulated = 0;
        while (this.m_MaxRows == 0 || this.m_NumberOfRowsPopulated < this.m_MaxRows) {
            if (!resultSet.next()) {
                this.m_WasPopulateCompleted = true;
                resultSet.close();
                return;
            }
            ++this.m_NumberOfRowsPopulated;
            Object[] objectArray = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = jdbcTmpResultSet.getTmpColumn(resultSet, n2 + 1);
                ++n2;
            }
            this.appendRow(objectArray);
        }
        if (this.m_NumberOfRowsPopulated < this.m_MaxRows) {
            this.m_WasPopulateCompleted = false;
        }
    }

    public boolean wasPopulateCompleted() throws SQLException {
        return this.m_WasPopulateCompleted;
    }

    public int getNumberOfRowsPopulated() throws SQLException {
        return this.m_NumberOfRowsPopulated;
    }

    public synchronized boolean next() throws SQLException {
        return ++this.m_RowNum < this.m_Rows.size();
    }

    public synchronized boolean previous() throws SQLException {
        return --this.m_RowNum > 0;
    }

    public synchronized boolean first() throws SQLException {
        return this.rewind();
    }

    public synchronized boolean last() throws SQLException {
        this.m_RowNum = this.m_Rows.size() - 1;
        return this.m_Rows.size() != 0;
    }

    public void close() throws SQLException {
        this.m_Rows = null;
        this.m_rsmd = null;
        this.m_RowNum = -1;
    }

    public boolean wasNull() throws SQLException {
        return this.m_WasNull;
    }

    public String getString(int n) throws SQLException {
        String string = (String)((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
        this.m_WasNull = string == null;
        return string;
    }

    public String getStringAtRow(int n, int n2) throws SQLException {
        return (String)((Object[])this.m_Rows.elementAt(n))[n2 - 1];
    }

    public byte[] getBytesAtRow(int n, int n2) throws SQLException {
        return (byte[])((Object[])this.m_Rows.elementAt(n))[n2 - 1];
    }

    public byte getByte(int n) throws SQLException {
        String string = (String)((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
        boolean bl = this.m_WasNull = string == null;
        if (string == null) {
            this.m_WasNull = true;
            return 0;
        }
        if (string.equals("")) {
            return 0;
        }
        return (byte)string.charAt(0);
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = (String)((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
        boolean bl = this.m_WasNull = string == null;
        if (string == null) {
            return false;
        }
        return !string.equals("") && !string.equals("0") && !string.equalsIgnoreCase("FALSE");
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getLong(n);
    }

    public int getInt(int n) throws SQLException {
        return (int)this.getLong(n);
    }

    public long getLong(int n) throws SQLException {
        String string = (String)((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
        boolean bl = this.m_WasNull = string == null;
        if (string == null) {
            return 0L;
        }
        if (string.equalsIgnoreCase("TRUE")) {
            string = "1";
        } else if (string.equalsIgnoreCase("FALSE")) {
            string = "0";
        }
        try {
            try {
                return Long.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new dbexcpException(86017, new Object[]{numberFormatException.toString()});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public float getFloat(int n) throws SQLException {
        return (float)this.getDouble(n);
    }

    public double getDouble(int n) throws SQLException {
        String string = (String)((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
        boolean bl = this.m_WasNull = string == null;
        if (string == null) {
            return 0.0;
        }
        try {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new dbexcpException(86017, new Object[]{numberFormatException.toString()});
            }
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        String string = (String)((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
        boolean bl = this.m_WasNull = string == null;
        if (string == null) {
            return null;
        }
        int n3 = this.m_rsmd.getColumnType(n);
        if (n3 == 6 || n3 == 8) {
            BigDecimal bigDecimal = new BigDecimal(Double.valueOf(string));
            return bigDecimal;
        }
        if (n3 == 7) {
            BigDecimal bigDecimal = new BigDecimal(Float.valueOf(string).floatValue());
            return bigDecimal;
        }
        if (n3 == 3 || n3 == 2) {
            BigDecimal bigDecimal = new BigDecimal(string);
            return bigDecimal;
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray = (byte[])((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
        boolean bl = this.m_WasNull = byArray == null;
        if (byArray == null) {
            return null;
        }
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        java.util.Date date = null;
        date = this.getInternalDate(n, 91);
        boolean bl = this.m_WasNull = date == null;
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public Time getTime(int n) throws SQLException {
        java.util.Date date = null;
        date = this.getInternalDate(n, 92);
        boolean bl = this.m_WasNull = date == null;
        if (date == null) {
            return null;
        }
        return new Time(date.getTime());
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        java.util.Date date = null;
        date = this.getInternalDate(n, 93);
        boolean bl = this.m_WasNull = date == null;
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this.getBinaryStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.m_WasNull = false;
        if (((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1] instanceof byte[]) {
            return new ByteArrayInputStream(this.getBytes(n));
        }
        if (((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1] instanceof String) {
            return new ByteArrayInputStream(this.getString(n).getBytes());
        }
        this.m_WasNull = true;
        return null;
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.m_rsmd;
    }

    public Object getObject(int n, int n2, int n3) throws SQLException {
        Object object = ((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
        this.m_WasNull = false;
        if (object == null) {
            this.m_WasNull = true;
            return null;
        }
        switch (n2) {
            case -7: {
                return new Boolean(this.getBoolean(n));
            }
            case -6: {
                return new Byte(this.getByte(n));
            }
            case 5: {
                return new Integer(this.getShort(n));
            }
            case 4: {
                return new Integer(this.getInt(n));
            }
            case -5: {
                return new Long(this.getLong(n));
            }
            case 6: {
                return new Float(this.getFloat(n));
            }
            case 7: {
                return new Float(this.getFloat(n));
            }
            case 8: {
                return new Double(this.getDouble(n));
            }
            case 2: {
                return this.getBigDecimal(n, n3);
            }
            case 3: {
                return this.getBigDecimal(n, n3);
            }
            case 1: {
                return this.getString(n);
            }
            case 12: {
                return this.getString(n);
            }
            case -1: {
                return this.getString(n);
            }
            case 91: {
                return this.getDate(n);
            }
            case 92: {
                return this.getTime(n);
            }
            case 93: {
                return this.getTimestamp(n);
            }
            case -2: {
                return this.getBytes(n);
            }
            case -3: {
                return this.getBytes(n);
            }
            case -4: {
                return this.getBytes(n);
            }
        }
        return object;
    }

    public Object getObject(int n, int n2) throws SQLException {
        return this.getObject(n, n2, 0);
    }

    public Object getObject(int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        return this.getObject(n, n2);
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Object getObject(String string, int n, int n2) throws SQLException {
        return this.getObject(this.findColumn(string), n, n2);
    }

    public Object getObject(String string, int n) throws SQLException {
        return this.getObject(this.findColumn(string), n, 0);
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        try {
            int n = 1;
            while (n <= this.m_rsmd.getColumnCount()) {
                if (this.m_rsmd.getColumnName(n).equalsIgnoreCase(string)) {
                    return n;
                }
                ++n;
            }
            throw new dbexcpException(86015, new Object[]{string});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Object getObject(int n, Map map) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Blob getBlob(int n) throws SQLException {
        return this.getBlob(n);
    }

    public Clob getClob(int n) throws SQLException {
        return this.getClob(n);
    }

    public Ref getRef(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public boolean absolute(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean relative(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void afterLast() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void beforeFirst() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void moveToCurrentRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void moveToInsertRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isFirst() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isBeforeFirst() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isLast() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean isAfterLast() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateString(int n, String string) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateNull(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateObject(int n, Object object) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateByte(int n, byte by) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateShort(int n, short s) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateInt(int n, int n2) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateLong(int n, long l) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateFloat(int n, float f) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateDouble(int n, double d) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateDate(int n, Date date) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateTime(int n, Time time) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void insertRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void deleteRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void cancelRowUpdates() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void refreshRow() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean rowUpdated() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean rowInserted() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean rowDeleted() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getType() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getConcurrency() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Statement getStatement() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void setFetchDirection(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public int getFetchSize() throws SQLException {
        return dbgaProperties.getPropertyFetchBlockSize();
    }

    public void setFetchSize(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    void setCell(int n, int n2, Object object) {
        Object[] objectArray = (Object[])this.m_Rows.elementAt(this.m_RowNum);
        if (objectArray == null) {
            objectArray = new Object[n2];
        }
        objectArray[n2 - 1] = object;
    }

    public void appendRow(Object[] objectArray) {
        this.m_Rows.addElement(objectArray);
    }

    public void setColString(int n, String string) {
        this.setCell(this.m_RowNum, n, string);
    }

    public void setColObject(int n, Object object) {
        this.setCell(this.m_RowNum, n, object);
    }

    public int size() {
        return this.m_Rows.size();
    }

    public boolean rewind() {
        this.m_RowNum = -1;
        return this.m_Rows.size() != 0;
    }

    private java.util.Date getInternalDate(int n, int n2) throws SQLException {
        try {
            String string = (String)((Object[])this.m_Rows.elementAt(this.m_RowNum))[n - 1];
            if (string == null) {
                return null;
            }
            if (n2 == 91) {
                return Date.valueOf(string);
            }
            if (n2 == 92) {
                return Time.valueOf(string);
            }
            if (n2 == 93) {
                return Timestamp.valueOf(string);
            }
            throw new dbexcpException(25000, Integer.toString(n2));
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        catch (Exception exception) {
            try {
                throw new dbexcpException(86016, new Object[]{exception.toString()});
            }
            catch (dbexcpException dbexcpException3) {
                throw dbexcpException3.getSQLException();
            }
        }
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            while (n <= this.m_rsmd.getColumnCount()) {
                stringBuffer.append("{ Column Name: " + this.m_rsmd.getColumnName(n));
                stringBuffer.append(", Display size: " + this.m_rsmd.getColumnDisplaySize(n));
                stringBuffer.append(", Label: " + this.m_rsmd.getColumnLabel(n));
                stringBuffer.append(", Type: " + this.m_rsmd.getColumnType(n));
                stringBuffer.append(", Type Name: " + this.m_rsmd.getColumnTypeName(n));
                stringBuffer.append(", Precision: " + this.m_rsmd.getPrecision(n));
                stringBuffer.append(", Scale: " + this.m_rsmd.getScale(n) + " }\n");
                ++n;
            }
            int n2 = 0;
            Enumeration enumeration = this.m_Rows.elements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray = (Object[])enumeration.nextElement();
                stringBuffer.append("row [" + n2 + "] ");
                int n3 = 0;
                while (n3 < objectArray.length) {
                    stringBuffer.append(objectArray[n3]);
                    if (n3 < objectArray.length - 1) {
                        stringBuffer.append(", ");
                    }
                    ++n3;
                }
                stringBuffer.append("\n");
                ++n2;
            }
            return stringBuffer.toString();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

