/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.jdbc.jdbcConnectionHandle;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class jdbcPooledConnection
implements PooledConnection {
    protected Connection m_Connection;
    private jdbcConnectionHandle m_CurrentConnectionHandle = null;
    private ConnectionEventListener m_ConnectionEventListener = null;

    public jdbcPooledConnection(String string, String string2, String string3) throws SQLException {
        try {
            Class.forName("com.pointbase.jdbc.jdbcUniversalDriver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException(classNotFoundException.getMessage());
        }
        this.m_Connection = DriverManager.getConnection(string, string2, string3);
    }

    public Connection getConnection() throws SQLException {
        this.validate();
        if (this.m_CurrentConnectionHandle != null) {
            this.m_CurrentConnectionHandle.close();
            this.m_CurrentConnectionHandle = null;
        }
        this.m_ConnectionEventListener = null;
        this.m_CurrentConnectionHandle = new jdbcConnectionHandle(this, this.m_Connection);
        return this.m_CurrentConnectionHandle;
    }

    public void close() throws SQLException {
        this.validate();
        this.m_CurrentConnectionHandle = null;
        this.m_ConnectionEventListener = null;
        this.m_Connection.close();
        this.m_Connection = null;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.m_ConnectionEventListener = connectionEventListener;
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (this.m_ConnectionEventListener == connectionEventListener) {
            this.m_ConnectionEventListener = null;
        }
    }

    void notifyCloseToListeners() throws SQLException {
        if (this.m_ConnectionEventListener != null) {
            this.m_ConnectionEventListener.connectionClosed(new ConnectionEvent(this));
        }
        this.m_CurrentConnectionHandle = null;
    }

    protected void validate() throws SQLException {
        if (this.m_Connection == null) {
            throw new dbexcpException(2003).getSQLException();
        }
    }
}

