/*
 * Decompiled with CFR 0.152.
 */
package com.pointbase.jdbc;

import com.pointbase.call.callCommand;
import com.pointbase.collxn.collxnHashtable;
import com.pointbase.collxn.collxnIEnumerator;
import com.pointbase.command.commandConstants;
import com.pointbase.dbexcp.dbexcpException;
import com.pointbase.def.defParameter;
import com.pointbase.jdbc.RegisterOutParameter;
import com.pointbase.jdbc.jdbcConnection;
import com.pointbase.jdbc.jdbcDatabaseMetaData;
import com.pointbase.jdbc.jdbcPreparedStatement;
import com.pointbase.jdbc.jdbcResultSet;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class jdbcCallableStatement
extends jdbcPreparedStatement
implements CallableStatement {
    private ResultSet m_rs = null;
    private boolean m_regiserOutParams = false;
    private collxnHashtable m_regOutParaTable = new collxnHashtable(10);

    public jdbcCallableStatement(jdbcConnection jdbcConnection2, int n, String string) throws SQLException {
        super(jdbcConnection2, n, string);
    }

    public jdbcCallableStatement(jdbcConnection jdbcConnection2, int n, String string, int n2, int n3) throws SQLException {
        super(jdbcConnection2, n, string, n2, n3);
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.m_apiStatement.getCommandType().getCommandId() != commandConstants.RETURNF && this.m_apiStatement.getCommandType().getCommandId() != commandConstants.CALL) {
            super.executeQuery();
        }
        try {
            if (this.m_apiStatement.getCommandType().getCommandId() == commandConstants.CALL) {
                int n = 0;
                collxnIEnumerator collxnIEnumerator2 = ((callCommand)this.m_apiStatement.getCommandType()).getRoutine().getRefRoutine().getParameterList();
                while (collxnIEnumerator2.hasMoreElements()) {
                    ++n;
                    defParameter defParameter2 = (defParameter)collxnIEnumerator2.nextElement();
                    if (defParameter2.getParameterMode() != 236) continue;
                    switch (defParameter2.getParameterDataType().getType()) {
                        case 2: 
                        case 3: {
                            this.setObject(n, (Object)new BigDecimal(0.0));
                            break;
                        }
                        case 4: {
                            this.setObject(n, (Object)new Integer(0));
                            break;
                        }
                        case 9: {
                            this.setObject(n, (Object)new Long(0L));
                            break;
                        }
                        case 5: {
                            this.setObject(n, (Object)new Short(0));
                            break;
                        }
                        case 6: 
                        case 8: {
                            this.setObject(n, (Object)new Double(0.0));
                            break;
                        }
                        case 7: {
                            this.setObject(n, (Object)new Float(0.0f));
                            break;
                        }
                        case 92: {
                            this.setObject(n, (Object)new Time(System.currentTimeMillis()), 92);
                            break;
                        }
                        case 91: {
                            this.setObject(n, (Object)new Date(System.currentTimeMillis()), 91);
                            break;
                        }
                        case 93: {
                            this.setObject(n, (Object)new Timestamp(System.currentTimeMillis()), 93);
                            break;
                        }
                        default: {
                            this.setNull(n, jdbcDatabaseMetaData.getSQLType(defParameter2.getParameterDataType().getType()));
                        }
                    }
                }
            }
            this.m_rs = (jdbcResultSet)super.executeQuery();
            this.m_rs.next();
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
        return this.m_rs;
    }

    public int[] executeBatch() throws BatchUpdateException {
        if (this.m_regiserOutParams) {
            throw new BatchUpdateException("OUT/INOUT Parameters are not allowed for executeBatch()", new int[0]);
        }
        return super.executeBatch();
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        try {
            if (!((callCommand)this.m_apiStatement.getCommandType()).getRoutine().getRefRoutine().isOutParameter(n)) {
                throw new dbexcpException(15060, new Object[]{new Integer(n)});
            }
            this.m_regOutParaTable.put(new Integer(n), new RegisterOutParameter(n, n2));
            this.m_regiserOutParams = true;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        try {
            if (!((callCommand)this.m_apiStatement.getCommandType()).getRoutine().getRefRoutine().isOutParameter(n)) {
                throw new dbexcpException(15060, new Object[]{new Integer(n)});
            }
            this.m_regOutParaTable.put(new Integer(n), new RegisterOutParameter(n, n2, n3));
            this.m_regiserOutParams = true;
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public boolean wasNull() throws SQLException {
        return this.m_rs.wasNull();
    }

    public String getString(int n) throws SQLException {
        this.validate();
        String string = null;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        string = registerOutParameter != null ? (String)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale()) : this.m_rs.getString(n);
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        this.validate();
        boolean bl = false;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        if (registerOutParameter != null) {
            Boolean bl2 = (Boolean)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale());
            if (bl2 == null) {
                return false;
            }
            bl = bl2;
        } else {
            bl = this.m_rs.getBoolean(n);
        }
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        this.validate();
        return this.m_rs.getByte(n);
    }

    public short getShort(int n) throws SQLException {
        this.validate();
        short s = 0;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        if (registerOutParameter != null) {
            Short s2 = (Short)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale());
            if (s2 == null) {
                return 0;
            }
            s = s2;
        } else {
            s = this.m_rs.getShort(n);
        }
        return s;
    }

    public int getInt(int n) throws SQLException {
        this.validate();
        int n2 = 0;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        if (registerOutParameter != null) {
            Integer n3 = (Integer)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale());
            if (n3 == null) {
                return 0;
            }
            n2 = n3;
        } else {
            n2 = this.m_rs.getInt(n);
        }
        return n2;
    }

    public long getLong(int n) throws SQLException {
        this.validate();
        long l = 0L;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        if (registerOutParameter != null) {
            Long l2 = (Long)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale());
            if (l2 == null) {
                return 0L;
            }
            l = l2;
        } else {
            l = this.m_rs.getLong(n);
        }
        return l;
    }

    public float getFloat(int n) throws SQLException {
        this.validate();
        float f = 0.0f;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        if (registerOutParameter != null) {
            Float f2 = (Float)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale());
            if (f2 == null) {
                return 0.0f;
            }
            f = f2.floatValue();
        } else {
            f = this.m_rs.getFloat(n);
        }
        return f;
    }

    public double getDouble(int n) throws SQLException {
        this.validate();
        double d = 0.0;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        if (registerOutParameter != null) {
            Double d2 = (Double)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale());
            if (d2 == null) {
                return 0.0;
            }
            d = d2;
        } else {
            d = this.m_rs.getDouble(n);
        }
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.validate();
        BigDecimal bigDecimal = null;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        bigDecimal = registerOutParameter != null ? (BigDecimal)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale()) : this.m_rs.getBigDecimal(n, n2);
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        this.validate();
        byte[] byArray = null;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        byArray = registerOutParameter != null ? (byte[])((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale()) : this.m_rs.getBytes(n);
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        this.validate();
        Date date = null;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        date = registerOutParameter != null ? (Date)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale()) : this.m_rs.getDate(n);
        return date;
    }

    public Time getTime(int n) throws SQLException {
        this.validate();
        Time time = null;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        time = registerOutParameter != null ? (Time)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale()) : this.m_rs.getTime(n);
        return time;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.validate();
        Timestamp timestamp = null;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        timestamp = registerOutParameter != null ? (Timestamp)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale()) : this.m_rs.getTimestamp(n);
        return timestamp;
    }

    public Object getObject(int n) throws SQLException {
        this.validate();
        Object object = null;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        object = registerOutParameter != null ? ((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale()) : this.m_rs.getObject(n);
        return object;
    }

    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Array getArray(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public Blob getBlob(int n) throws SQLException {
        this.validate();
        return this.m_rs.getBlob(n);
    }

    public Clob getClob(int n) throws SQLException {
        this.validate();
        return this.m_rs.getClob(n);
    }

    public Ref getRef(int n) throws SQLException {
        try {
            throw new dbexcpException(86010, new Object[]{"2.0"});
        }
        catch (dbexcpException dbexcpException2) {
            throw dbexcpException2.getSQLException();
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.validate();
        BigDecimal bigDecimal = null;
        RegisterOutParameter registerOutParameter = null;
        registerOutParameter = this.getRegisterOutParameter(n);
        bigDecimal = registerOutParameter != null ? (BigDecimal)((jdbcResultSet)this.m_rs).getObject(n, registerOutParameter.getType(), registerOutParameter.getScale()) : this.m_rs.getBigDecimal(n);
        return bigDecimal;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.validate();
        return this.m_rs.getDate(n, calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.validate();
        return this.m_rs.getTime(n, calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.validate();
        return this.m_rs.getTimestamp(n, calendar);
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.validate();
        return this.m_rs.getObject(n, map);
    }

    public void close() throws SQLException {
        this.clearParameters();
        super.close();
    }

    public static String parse(String string) {
        return string.replace('{', ' ').replace('}', ' ').trim();
    }

    private void validate() throws SQLException {
        if (this.m_rs == null) {
            throw new SQLException("Invalid ResultSet State");
        }
    }

    private RegisterOutParameter getRegisterOutParameter(int n) {
        RegisterOutParameter registerOutParameter = null;
        try {
            registerOutParameter = (RegisterOutParameter)this.m_regOutParaTable.get(new Integer(n));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return registerOutParameter;
    }
}

