/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import de.hunsicker.antlr.CommonHiddenStreamToken;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.LeftParenthesisPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.ParenthesesScope;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.RightParenthesisPrinter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

abstract class OperatorPrinter
extends AbstractPrinter {
    protected OperatorPrinter() {
    }

    protected boolean performWrap(int length, AST node, boolean wrapBefore, boolean paddOperator, NodeWriter out) throws IOException {
        if (out.mode == 1) {
            int lineLength;
            int offset = out.column + length + (paddOperator ? 2 : 0);
            if (wrapBefore) {
                offset += node.getText().length();
            }
            if (out.column >= (lineLength = settings.getInt(ConventionKeys.LINE_LENGTH, 80)) || offset > lineLength) {
                out.printNewline();
                this.printIndentation(out);
                return true;
            }
        }
        return false;
    }

    protected AST printLeftHandSide(AST node, NodeWriter out) throws IOException {
        AST first = node.getFirstChild();
        switch (first.getType()) {
            case 84: {
                int count = 0;
                AST child = first;
                while (child != null) {
                    PrinterFactory.create(child).print(child, out);
                    switch (child.getType()) {
                        case 84: {
                            ++count;
                            break;
                        }
                        case 85: {
                            if (--count != 0) break;
                            return child.getNextSibling();
                        }
                    }
                    child = child.getNextSibling();
                }
                throw new IllegalStateException("missing closing parenthesis");
            }
        }
        PrinterFactory.create(first).print(first, out);
        return first.getNextSibling();
    }

    protected void printRightHandSide(AST node, NodeWriter out) throws IOException {
        AST child = node;
        while (child != null) {
            PrinterFactory.create(child).print(child, out);
            child = child.getNextSibling();
        }
    }

    int getPrecedence(AST node) {
        int result = 0;
        switch (node.getType()) {
            case 118: {
                result = 1;
                break;
            }
            case 117: {
                result = 2;
                break;
            }
            case 116: {
                result = 3;
                break;
            }
            case 114: {
                result = 4;
                break;
            }
            case 113: {
                result = 5;
                break;
            }
            case 115: {
                result = 6;
                break;
            }
            case 109: {
                result = 7;
                break;
            }
            case 108: {
                result = 8;
                break;
            }
            case 112: {
                result = 9;
                break;
            }
            case 111: {
                result = 10;
                break;
            }
            case 110: {
                result = 11;
                break;
            }
            case 89: {
                result = 12;
                break;
            }
            case 91: {
                result = 13;
                break;
            }
            case 119: {
                result = 14;
                break;
            }
            case 120: {
                result = 15;
                break;
            }
            case 121: {
                result = 16;
                break;
            }
            case 122: {
                result = 17;
                break;
            }
            case 123: {
                result = 18;
                break;
            }
            case 124: {
                result = 19;
                break;
            }
            case 125: {
                result = 20;
                break;
            }
            case 126: {
                result = 21;
                break;
            }
            case 130: {
                result = 22;
                break;
            }
            case 129: {
                result = 23;
                break;
            }
            case 128: {
                result = 24;
                break;
            }
            case 127: {
                result = 25;
                break;
            }
            case 133: {
                result = 26;
                break;
            }
            case 132: {
                result = 27;
                break;
            }
            case 136: {
                result = 28;
                break;
            }
            case 135: {
                result = 29;
                break;
            }
            case 138: {
                result = 30;
                break;
            }
            case 137: {
                result = 31;
                break;
            }
            case 70: {
                result = 32;
            }
        }
        return result;
    }

    static boolean canWrap(AST operator, NodeWriter out) {
        if (out.mode != 1) {
            return false;
        }
        switch (operator.getType()) {
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 135: 
            case 136: {
                return true;
            }
        }
        return false;
    }

    boolean isTopMost(JavaNode node) {
        JavaNode parent = node.getParent();
        switch (parent.getType()) {
            case 32: {
                return true;
            }
        }
        return false;
    }

    void addParentheses(JavaNode operand) {
        JavaNode parent = operand.getParent();
        JavaNode lparen = new JavaNode(84, "(");
        JavaNode rparen = new JavaNode(85, ")");
        if (parent.getFirstChild() == operand) {
            parent.setFirstChild(lparen);
            lparen.setPreviousSibling(parent);
        }
        lparen.setParent(parent);
        lparen.setNextSibling(operand);
        rparen.setParent(parent);
        rparen.setPreviousSibling(operand);
        rparen.setNextSibling(operand.getNextSibling());
        operand.setPreviousSibling(lparen);
        operand.setNextSibling(rparen);
    }

    boolean printWithParentheses(JavaNode node, AST leftParen, AST rightParen, NodeWriter out) throws IOException {
        JavaNode n = JavaNodeHelper.getLastChild(node);
        if (n == null && n.hasCommentsAfter()) {
            LeftParenthesisPrinter.getInstance().print(leftParen, out);
            if (out.mode == 1) {
                out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
            }
            Marker marker = out.state.markers.add();
            PrinterFactory.create(node).print(node, out);
            out.state.markers.remove(marker);
            RightParenthesisPrinter.getInstance().print(rightParen, out);
            if (out.mode == 1) {
                out.state.parenScope.removeFirst();
            }
            return false;
        }
        CommonHiddenStreamToken t = n.getHiddenAfter();
        n.setHiddenAfter(null);
        LeftParenthesisPrinter.getInstance().print(leftParen, out);
        if (out.mode == 1) {
            out.state.parenScope.addFirst(new ParenthesesScope(out.state.paramLevel));
        }
        Marker marker = out.state.markers.add();
        out.state.markers.remove(marker);
        PrinterFactory.create(node).print(node, out);
        RightParenthesisPrinter.getInstance().print(rightParen, out);
        if (out.mode == 1) {
            out.state.parenScope.removeFirst();
        }
        n.setHiddenAfter(t);
        this.printCommentsAfter(n, false, false, out);
        return true;
    }

    private static boolean isHigherLevel(JavaNode operator) {
        switch (operator.getParent().getType()) {
            case 35: 
            case 36: 
            case 70: 
            case 89: 
            case 91: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: {
                AST child = operator.getFirstChild();
                while (child != null) {
                    switch (child.getType()) {
                        case 70: 
                        case 89: 
                        case 91: 
                        case 108: 
                        case 109: 
                        case 110: 
                        case 111: 
                        case 112: 
                        case 113: 
                        case 114: 
                        case 115: 
                        case 116: 
                        case 117: 
                        case 119: 
                        case 120: 
                        case 121: 
                        case 122: 
                        case 123: 
                        case 124: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 128: 
                        case 129: 
                        case 130: 
                        case 132: 
                        case 133: 
                        case 135: 
                        case 136: 
                        case 137: 
                        case 138: {
                            return true;
                        }
                    }
                    child = child.getNextSibling();
                }
                return false;
            }
        }
        return true;
    }

    private static boolean isLowerLevel(JavaNode operator) {
        AST child = operator.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 35: 
                case 36: 
                case 70: 
                case 89: 
                case 91: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 132: 
                case 133: 
                case 135: 
                case 136: 
                case 137: 
                case 138: 
                case 139: 
                case 140: 
                case 141: 
                case 142: {
                    return true;
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }
}

