/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.RecognitionException;
import de.hunsicker.antlr.TokenBuffer;
import de.hunsicker.antlr.TokenStreamException;
import de.hunsicker.antlr.TokenStreamRecognitionException;
import de.hunsicker.antlr.collections.AST;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.language.Lexer;
import de.hunsicker.jalopy.language.Parser;
import de.hunsicker.util.ChainingRuntimeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Recognizer {
    public static final String UNKNOWN_FILE = "<unknown>";
    protected Lexer lexer;
    protected Parser parser;
    boolean finished;
    boolean running;

    public Recognizer(Parser parser, Lexer lexer) {
        this.parser = parser;
        this.lexer = lexer;
    }

    protected Recognizer() {
    }

    public void setColumn(int column) {
        this.lexer.setColumn(column);
    }

    public int getColumn() {
        return this.lexer.getColumn();
    }

    public FileFormat getFileFormat() {
        if (!this.finished) {
            throw new IllegalStateException("nothing parsed yet");
        }
        return this.lexer.getFileFormat();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Lexer getLexer() {
        return this.lexer;
    }

    public void setLine(int line) {
        this.lexer.setLine(line);
    }

    public int getLine() {
        return this.lexer.getLine();
    }

    public AST getParseTree() {
        return this.parser.getParseTree();
    }

    public Parser getParser() {
        return this.parser;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void parse(Reader in, String filename) {
        if (this.running) {
            throw new IllegalStateException("parser already running");
        }
        this.finished = false;
        this.running = true;
        this.lexer.setInputBuffer(in);
        this.lexer.setFilename(filename);
        this.parser.setTokenBuffer(new TokenBuffer(this.lexer));
        this.parser.setFilename(filename);
        try {
            try {
                this.parser.parse();
            }
            catch (RecognitionException ex) {
                throw new ParseException(ex);
            }
            catch (TokenStreamRecognitionException ex) {
                throw new ParseException(ex);
            }
            catch (TokenStreamException ex) {
                throw new ParseException(ex);
            }
            Object var7_3 = null;
            this.finished = true;
            this.running = false;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            this.finished = true;
            this.running = false;
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(File file) {
        if (!file.exists() || !file.isFile()) return;
        BufferedReader in = null;
        in = new BufferedReader(new FileReader(file));
        this.parse(in, file.getAbsolutePath());
        Object var5_3 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (FileNotFoundException neverOccurs) {
                Object var5_4 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void parse(String str, String filename) throws IOException {
        BufferedReader in = new BufferedReader(new StringReader(str));
        this.parse(in, filename);
        in.close();
    }

    public void reset() {
        this.running = false;
        this.finished = false;
        this.lexer.reset();
        this.parser.reset();
    }

    public static final class ParseException
    extends ChainingRuntimeException {
        public ParseException(Throwable cause) {
            super(cause);
        }
    }
}

