/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNode;

public final class JavaNodeHelper {
    private JavaNodeHelper() {
    }

    public static boolean isAbstractMethod(AST node) {
        boolean result = false;
        switch (node.getType()) {
            case 13: {
                AST child = node.getFirstChild();
                while (child != null) {
                    switch (child.getType()) {
                        case 55: {
                            result = true;
                        }
                    }
                    child = child.getNextSibling();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("no METHOD_DEF -- " + node);
            }
        }
        return result;
    }

    public static boolean isAnonymousInnerClass(AST node) {
        switch (node.getType()) {
            case 18: 
            case 19: {
                return ((JavaNode)node).getParent().getParent().getType() == 146;
            }
        }
        throw new IllegalArgumentException("invalid node -- " + node);
    }

    public static boolean isBlockNext(AST node) {
        if (node == null) {
            return false;
        }
        AST next = node.getNextSibling();
        if (next == null) {
            JavaNode parent = ((JavaNode)node).getParent();
            switch (parent.getType()) {
                case 9: 
                case 17: {
                    return false;
                }
                case 22: {
                    AST implementsClause = parent.getNextSibling();
                    if (implementsClause.getFirstChild() == null) {
                        return JavaNodeHelper.isBlockNext(implementsClause);
                    }
                    return false;
                }
                case 23: {
                    return JavaNodeHelper.isBlockNext(parent);
                }
            }
            return false;
        }
        switch (next.getType()) {
            case 7: 
            case 10: 
            case 11: 
            case 50: 
            case 89: {
                return true;
            }
        }
        return false;
    }

    public static boolean isChained(AST node) {
        switch (node.getType()) {
            case 69: {
                AST next = node.getFirstChild();
                switch (next.getType()) {
                    case 31: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getDottedName(AST tree) {
        String result = null;
        switch (tree.getType()) {
            case 69: {
                AST left = tree.getFirstChild();
                AST right = left.getNextSibling();
                result = JavaNodeHelper.getDottedName(left) + '.' + JavaNodeHelper.getDottedName(right);
                break;
            }
            case 21: {
                StringBuffer buf = new StringBuffer(30);
                AST left = tree.getFirstChild();
                AST right = left.getNextSibling();
                buf.append(JavaNodeHelper.getDottedName(left));
                if (right != null) {
                    buf.append('.');
                    buf.append(JavaNodeHelper.getDottedName(right));
                }
                buf.append(" []");
                result = buf.toString();
                break;
            }
            case 31: {
                result = JavaNodeHelper.getDottedName(tree.getFirstChild()) + "()";
                break;
            }
            default: {
                result = tree.getText();
            }
        }
        return result;
    }

    public static boolean isEmptyBlock(AST node) {
        switch (node.getType()) {
            case 10: 
            case 11: 
            case 50: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid type -- " + node);
            }
        }
        boolean result = false;
        JavaNode child = (JavaNode)node.getFirstChild();
        block8: while (child != null) {
            switch (child.getType()) {
                case 11: 
                case 50: {
                    result = JavaNodeHelper.isEmptyBlock(child);
                    break block8;
                }
                case 7: {
                    if (!child.hasCommentsBefore() && !child.hasCommentsAfter()) break;
                    return false;
                }
                case 8: {
                    return !child.hasCommentsBefore();
                }
                default: {
                    return child == null;
                }
            }
            child = (JavaNode)child.getNextSibling();
        }
        return result;
    }

    public static AST getFirstChainLink(AST node) {
        AST dot = node.getFirstChild();
        if (JavaNodeHelper.isChained(dot)) {
            return JavaNodeHelper.getFirstChainLink(dot.getFirstChild());
        }
        return node;
    }

    public static AST getFirstChild(AST node, int type) {
        AST result = null;
        AST child = node.getFirstChild();
        while (child != null) {
            if (child.getType() == type) {
                result = child;
                break;
            }
            child = child.getNextSibling();
        }
        return result;
    }

    public static boolean isFreestandingBlock(JavaNode node) {
        boolean result = false;
        switch (node.getParent().getType()) {
            case 11: 
            case 15: {
                result = true;
            }
        }
        return result;
    }

    public static boolean isInnerClass(AST node) {
        switch (node.getType()) {
            case 18: 
            case 19: {
                return ((JavaNode)node).getParent().getType() == 10;
            }
        }
        throw new IllegalArgumentException("invalid node -- " + node);
    }

    public static JavaNode getLastChild(AST node) {
        if (node == null) {
            return null;
        }
        switch (node.getType()) {
            case 69: {
                AST last;
                AST child = last = node.getFirstChild();
                if (child != null) {
                    switch (child.getType()) {
                        case 69: {
                            last = child;
                        }
                    }
                }
                return JavaNodeHelper.getLastChild(last.getNextSibling());
            }
        }
        AST first = node.getFirstChild();
        if (first == null) {
            return (JavaNode)node;
        }
        AST second = first.getNextSibling();
        if (second == null) {
            return (JavaNode)first;
        }
        AST last = second;
        AST child = second;
        while (child != null) {
            last = child;
            child = child.getNextSibling();
        }
        return JavaNodeHelper.getLastChild(last);
    }

    public static boolean isLocalVariable(AST node) {
        if (node.getType() != 14) {
            throw new IllegalArgumentException("no VARIABLE_DEF node -- " + node);
        }
        return ((JavaNode)node).getParent().getType() != 10;
    }

    public static AST advanceToFirstNonParen(AST lparen) {
        if (lparen == null) {
            throw new NullPointerException();
        }
        if (lparen.getType() != 84) {
            throw new IllegalArgumentException(lparen + " no LPAREN");
        }
        AST next = lparen.getNextSibling();
        while (next != null) {
            switch (next.getType()) {
                case 84: {
                    break;
                }
                default: {
                    return next;
                }
            }
            next = next.getNextSibling();
        }
        return null;
    }
}

