/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.deployment;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerMode;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.AbstractKernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.logging.Logger;
import org.jboss.util.JBossStringBuilder;

public class AbstractKernelDeployer {
    private static final Logger log = Logger.getLogger((Class)AbstractKernelDeployer.class);
    protected Kernel kernel;
    protected ControllerState requiredState;
    protected ControllerMode mode;

    public AbstractKernelDeployer(Kernel kernel) {
        this(kernel, null, null);
    }

    public AbstractKernelDeployer(Kernel kernel, ControllerState requiredState, ControllerMode mode) {
        if (kernel == null) {
            throw new IllegalArgumentException("Null kernel");
        }
        this.kernel = kernel;
        this.requiredState = requiredState;
        this.mode = mode;
    }

    public void deploy(KernelDeployment deployment) throws Throwable {
        if (deployment.isInstalled()) {
            throw new IllegalArgumentException("Already installed " + deployment.getName());
        }
        KernelController controller = this.kernel.getController();
        try {
            this.deployBeans(controller, deployment);
            deployment.setInstalled(true);
        }
        catch (Throwable t) {
            this.undeploy(deployment);
            throw t;
        }
    }

    public void change(KernelDeployment deployment, ControllerState state) throws Throwable {
        if (!deployment.isInstalled()) {
            throw new IllegalStateException("Not installed " + deployment.getName());
        }
        KernelController controller = this.kernel.getController();
        this.changeBeans(controller, deployment, state);
    }

    public void undeploy(KernelDeployment deployment) {
        KernelController controller = this.kernel.getController();
        this.undeployBeans(controller, deployment);
        deployment.setInstalled(false);
    }

    public void validate() throws Throwable {
        KernelController controller = this.kernel.getController();
        Set notInstalled = controller.getNotInstalled();
        this.internalValidate(notInstalled);
    }

    public void validate(KernelDeployment deployment) throws Throwable {
        HashSet notInstalled = new HashSet(deployment.getInstalledContexts());
        this.internalValidate(notInstalled);
    }

    protected void internalValidate(Set notInstalled) throws Throwable {
        if (!notInstalled.isEmpty()) {
            Iterator i = notInstalled.iterator();
            while (i.hasNext()) {
                KernelControllerContext context = (KernelControllerContext)i.next();
                if (!context.getState().equals((Object)context.getRequiredState())) continue;
                i.remove();
            }
            if (!notInstalled.isEmpty()) {
                HashSet<KernelControllerContext> errors = new HashSet<KernelControllerContext>();
                HashSet<KernelControllerContext> incomplete = new HashSet<KernelControllerContext>();
                Iterator i2 = notInstalled.iterator();
                while (i2.hasNext()) {
                    KernelControllerContext ctx = (KernelControllerContext)i2.next();
                    if (ctx.getState().equals((Object)ControllerState.ERROR)) {
                        errors.add(ctx);
                        continue;
                    }
                    incomplete.add(ctx);
                }
                JBossStringBuilder buffer = new JBossStringBuilder();
                buffer.append("Incompletely deployed:\n");
                if (errors.size() != 0) {
                    buffer.append("\n*** DEPLOYMENTS IN ERROR:\n");
                    Iterator i3 = errors.iterator();
                    while (i3.hasNext()) {
                        KernelControllerContext ctx = (KernelControllerContext)i3.next();
                        buffer.append(ctx.getName()).append(" -> ").append(ctx.getError().toString()).append('\n');
                    }
                }
                if (incomplete.size() != 0) {
                    KernelController controller = this.kernel.getController();
                    buffer.append("\n*** DEPLOYMENTS MISSING DEPENDENCIES:\n");
                    Iterator i4 = incomplete.iterator();
                    while (i4.hasNext()) {
                        KernelControllerContext ctx = (KernelControllerContext)i4.next();
                        buffer.append(ctx.getName()).append(" -> ");
                        DependencyInfo dependsInfo = ctx.getDependencyInfo();
                        Set depends = dependsInfo.getIDependOn(null);
                        Iterator j = depends.iterator();
                        while (j.hasNext()) {
                            DependencyItem item = (DependencyItem)j.next();
                            buffer.append(item.getIDependOn()).append('{').append(item.getWhenRequired().getStateString());
                            buffer.append(':');
                            ControllerContext other = controller.getContext(item.getIDependOn(), null);
                            if (other == null) {
                                buffer.append("NOT FOUND");
                            } else {
                                buffer.append(other.getState().getStateString());
                            }
                            buffer.append('}');
                            if (!j.hasNext()) continue;
                            buffer.append(", ");
                        }
                        buffer.append('\n');
                    }
                }
                throw new IllegalStateException(buffer.toString());
            }
        }
    }

    protected void deployBeans(KernelController controller, KernelDeployment deployment) throws Throwable {
        List beans = deployment.getBeans();
        if (beans != null) {
            for (int i = 0; i < beans.size(); ++i) {
                BeanMetaData metaData = (BeanMetaData)beans.get(i);
                KernelControllerContext context = this.deployBean(controller, metaData);
                deployment.addInstalledContext(context);
            }
        }
    }

    protected KernelControllerContext deployBean(KernelController controller, BeanMetaData bean) throws Throwable {
        AbstractKernelControllerContext context = new AbstractKernelControllerContext(null, bean, null);
        if (this.requiredState != null) {
            context.setRequiredState(this.requiredState);
        }
        if (this.mode != null) {
            context.setMode(this.mode);
        }
        controller.install(context);
        return context;
    }

    protected void changeBeans(KernelController controller, KernelDeployment deployment, ControllerState state) throws Throwable {
        Set contexts = deployment.getInstalledContexts();
        if (contexts != null) {
            Iterator i = contexts.iterator();
            while (i.hasNext()) {
                KernelControllerContext context = (KernelControllerContext)i.next();
                this.changeBean(controller, context, state);
            }
        }
    }

    protected void changeBean(KernelController controller, KernelControllerContext context, ControllerState state) throws Throwable {
        if (ControllerMode.MANUAL.equals((Object)context.getMode()) && !ControllerState.ERROR.equals((Object)context.getState())) {
            controller.change(context, state);
        }
    }

    protected void undeployBeans(KernelController controller, KernelDeployment deployment) {
        Set contexts = deployment.getInstalledContexts();
        if (!contexts.isEmpty()) {
            Iterator i = contexts.iterator();
            while (i.hasNext()) {
                KernelControllerContext context = (KernelControllerContext)i.next();
                try {
                    this.undeployBean(controller, context);
                    deployment.removeInstalledContext(context);
                }
                catch (Throwable ignored) {
                    log.warn((Object)("Ignored error during uninstall of " + context), ignored);
                }
            }
        }
    }

    protected void undeployBean(KernelController controller, KernelControllerContext context) throws Throwable {
        if (!ControllerState.ERROR.equals((Object)context.getState())) {
            controller.uninstall(context.getName());
        }
    }
}

