/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.AutoGridBagLayout;
import ccl.util.Util;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class MemoryPanel
extends JPanel
implements Runnable,
ActionListener,
ItemListener {
    private JComboBox _jcbInterval = new JComboBox();
    private JButton _btnUpdate = new JButton("Update Now");
    private JButton _btnGC = new JButton("Collect Garbage");
    private JButton _btnOK = new JButton("OK");
    private JLabel _lblInUseMemory = new JLabel("000,000,000");
    private JLabel _lblTotalMemory = new JLabel("000,000,000");
    private JLabel _lblPercentage = new JLabel();
    private NumberFormat _pNumberFormat;
    private JProgressBar _pJProgressBar = null;
    private int _updateInterval = 2;
    private Thread _pThread;
    private boolean _bExit = false;

    private void _updateValues() {
        Runtime pRuntime = Runtime.getRuntime();
        long lTotalMemory = pRuntime.totalMemory();
        long lInUseMemory = lTotalMemory - pRuntime.freeMemory();
        this._lblInUseMemory.setText(this._pNumberFormat.format(lInUseMemory));
        this._lblTotalMemory.setText(this._pNumberFormat.format(lTotalMemory));
        int percentage = (int)(lInUseMemory * 1000L / lTotalMemory);
        String sPercentage = "(" + Util.itoa(percentage / 10) + "." + Util.itoa(percentage % 10) + " %)";
        this._lblPercentage.setText(sPercentage);
        this._pJProgressBar.setValue(percentage);
        Util.debug("MemoryPanel._updateValues().percentage: " + percentage);
        Util.debug("MemoryPanel._updateValues()._pJProgressBar.getMinimum(): " + this._pJProgressBar.getMinimum());
        Util.debug("MemoryPanel._updateValues()._pJProgressBar.getMaximum(): " + this._pJProgressBar.getMaximum());
    }

    public MemoryPanel() {
        AutoGridBagLayout agblMemory = new AutoGridBagLayout();
        agblMemory.setInsets(3);
        this.setLayout(agblMemory);
        this._pJProgressBar = new JProgressBar();
        this._pJProgressBar.setMinimum(0);
        this._pJProgressBar.setMaximum(1000);
        agblMemory.setAnchor(17);
        this.add(new JLabel("Update every "));
        this._pNumberFormat = NumberFormat.getInstance(Locale.US);
        this._jcbInterval.addItem("1");
        this._jcbInterval.addItem("2");
        this._jcbInterval.addItem("3");
        this._jcbInterval.addItem("4");
        this._jcbInterval.addItem("5");
        this._jcbInterval.addItem("10");
        this._jcbInterval.addItem("20");
        this._jcbInterval.addItem("30");
        this._jcbInterval.addItem("60");
        this._jcbInterval.addItem("300  ");
        this._jcbInterval.setSelectedIndex(1);
        this._updateInterval = 2;
        this._jcbInterval.addItemListener(this);
        agblMemory.setAnchor(10);
        this.add(this._jcbInterval);
        agblMemory.setAnchor(17);
        this.add(new JLabel(" seconds. "));
        this._btnUpdate.addActionListener(this);
        agblMemory.setFillHorizontal();
        this.add(this._btnUpdate);
        agblMemory.setFillNone();
        agblMemory.endLine();
        this.add(new JLabel("Memory in use: "));
        this._updateValues();
        agblMemory.setAnchor(13);
        this.add(this._lblInUseMemory);
        agblMemory.setAnchor(17);
        this.add(new JLabel(" bytes"));
        this.add(this._lblPercentage);
        agblMemory.endLine();
        this.add(new JLabel("Total memory: "));
        agblMemory.setAnchor(13);
        this.add(this._lblTotalMemory);
        agblMemory.setAnchor(17);
        this.add(new JLabel(" bytes"));
        this._btnGC.addActionListener(this);
        this.add(this._btnGC);
        agblMemory.endLine();
        agblMemory.setExtend(4, 1);
        agblMemory.setFillHorizontal();
        agblMemory.setAnchor(10);
        this.add(this._pJProgressBar);
        agblMemory.setFillNone();
        agblMemory.setExtend(1, 1);
        agblMemory.endLine();
    }

    public void setBackground(Color pColor_) {
        super.setBackground(pColor_);
        if (this._pJProgressBar != null) {
            this._pJProgressBar.setBackground(pColor_);
        }
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        Object oSource = pActionEvent_.getSource();
        if (oSource == this._btnUpdate) {
            this._pThread.interrupt();
        } else if (oSource == this._btnGC) {
            Runtime.getRuntime().gc();
            this._pThread.interrupt();
        }
    }

    public void itemStateChanged(ItemEvent pItemEvent_) {
        this._updateInterval = Util.atoi(this._jcbInterval.getSelectedItem().toString());
        this._pThread.interrupt();
    }

    public void run() {
        while (this._pThread != null) {
            if (this._bExit) {
                this._pThread = null;
                break;
            }
            this._updateValues();
            this.repaint();
            try {
                Thread.sleep(this._updateInterval * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void start() {
        this._pThread = new Thread(this);
        this._pThread.start();
    }

    public void stop() {
        this._bExit = true;
        if (this._pThread != null) {
            this._pThread.interrupt();
        }
    }
}

