/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.Highlightable;
import ccl.swing.HighlightedListCellRenderer;
import ccl.util.Util;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;

public class HighlightedList
extends JList {
    private Color _clrHighlight = Color.black;
    private StringBuffer _sbScroll2String = new StringBuffer();
    private static final int MAX_TIME_TWEEN_KEYSTROKES = 10000;

    private void highlightSelectedValue() {
        Object oValue = this.getSelectedValue();
        if (oValue != null && oValue instanceof Highlightable) {
            ((Highlightable)oValue).setHighlightable(true);
        }
    }

    private void scrollToKeyPressed(StringBuffer sbKey_) {
        Util.debug(this, "scrollToKeyPressed(..).sbKey_: " + sbKey_);
        ListModel pListModel = this.getModel();
        int i = 0;
        while (i < pListModel.getSize()) {
            String sElement = pListModel.getElementAt(i).toString();
            String sLowerElement = sElement.toLowerCase();
            Util.debug(this, "scrollToKeyPressed(..).sElement: " + sElement);
            if (sLowerElement.startsWith(sbKey_.toString())) {
                this.setSelectedValue(sElement, true);
                break;
            }
            ++i;
        }
    }

    private void _init() {
        this.setCellRenderer(new HighlightedListCellRenderer());
        this.invalidate();
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent pMouseEvent_) {
                HighlightedList.this.highlightSelectedValue();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent pKeyEvent_) {
                int keyCode = pKeyEvent_.getKeyCode();
                if (keyCode == 10) {
                    HighlightedList.this.highlightSelectedValue();
                }
            }

            public void keyTyped(KeyEvent pKeyEvent_) {
                char c = pKeyEvent_.getKeyChar();
                HighlightedList.this._sbScroll2String.setLength(0);
                HighlightedList.this._sbScroll2String.append(c);
                HighlightedList.this.scrollToKeyPressed(HighlightedList.this._sbScroll2String);
            }
        });
    }

    public HighlightedList() {
        this._init();
    }

    public HighlightedList(Vector vData_) {
        super(vData_);
        this._init();
    }

    public HighlightedList(ListModel lmData_) {
        super(lmData_);
        this._init();
    }

    public void setHighlight(Color clrHighlight_) {
        this._clrHighlight = new Color(clrHighlight_.getRGB());
    }

    public Color getHighlight() {
        return new Color(this._clrHighlight.getRGB());
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else if (!anObject.equals(this.getSelectedValue())) {
            ListModel dm = this.getModel();
            int i = 0;
            int c = dm.getSize();
            while (i < c) {
                if (dm.getElementAt(i).equals(anObject)) {
                    this.setSelectedIndex(i);
                    if (shouldScroll) {
                        this.ensureIndexIsVisible(i);
                    }
                    this.repaint();
                    return;
                }
                ++i;
            }
            this.setSelectedIndex(-1);
        }
        this.repaint();
    }
}

